/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.implementation.PollContextRequiredException;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;

final class SyncOverAsyncPoller<T, U>
implements SyncPoller<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SyncOverAsyncPoller.class);
    private final Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation;
    private final BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation;
    private final Function<PollingContext<T>, Mono<U>> fetchResultOperation;
    private final PollResponse<T> activationResponse;
    private final PollingContext<T> pollingContext = new PollingContext();
    private volatile PollingContext<T> terminalPollContext;
    private volatile Duration pollInterval;

    SyncOverAsyncPoller(Duration pollInterval, Function<PollingContext<T>, PollResponse<T>> syncActivationOperation, Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation, Function<PollingContext<T>, Mono<U>> fetchResultOperation) {
        Objects.requireNonNull(pollInterval, "'pollInterval' cannot be null.");
        if (pollInterval.isNegative() || pollInterval.isZero()) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'defaultPollInterval' is not allowed."));
        }
        this.pollInterval = pollInterval;
        Objects.requireNonNull(syncActivationOperation, "'syncActivationOperation' cannot be null.");
        this.pollOperation = Objects.requireNonNull(pollOperation, "'pollOperation' cannot be null.");
        this.cancelOperation = Objects.requireNonNull(cancelOperation, "'cancelOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(fetchResultOperation, "'fetchResultOperation' cannot be null.");
        this.activationResponse = syncActivationOperation.apply(this.pollingContext);
        this.pollingContext.setOnetimeActivationResponse(this.activationResponse);
        this.pollingContext.setLatestResponse(this.activationResponse);
        if (this.activationResponse.getStatus().isComplete()) {
            this.terminalPollContext = this.pollingContext;
        }
    }

    @Override
    public PollResponse<T> poll() {
        return this.pollOperation.apply(this.pollingContext).map(response -> {
            this.pollingContext.setLatestResponse((PollResponse<T>)response);
            if (response.getStatus().isComplete()) {
                this.terminalPollContext = this.pollingContext.copy();
            }
            return response;
        }).block();
    }

    @Override
    public PollResponse<T> waitForCompletion() {
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        return PollingUtil.pollingLoopAsync(context, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).last().map(response -> {
            this.terminalPollContext = context;
            return PollingUtil.toPollResponse(response);
        }).block();
    }

    @Override
    public PollResponse<T> waitForCompletion(Duration timeout2) {
        PollingUtil.validateTimeout(timeout2, LOGGER);
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        return (PollResponse)PollingUtil.pollingLoopAsync(context, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).take(timeout2).switchIfEmpty(Mono.error(() -> new TimeoutException("Polling didn't complete before the timeout period."))).last().flatMap(response -> {
            if (response != null && response.getStatus().isComplete()) {
                this.terminalPollContext = context;
                return Mono.just(PollingUtil.toPollResponse(response));
            }
            return Mono.error(new TimeoutException("Polling didn't complete before the timeout period."));
        }).block();
    }

    @Override
    public PollResponse<T> waitUntil(LongRunningOperationStatus statusToWaitFor) {
        Objects.requireNonNull(statusToWaitFor, "'statusToWaitFor' cannot be null.");
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        return PollingUtil.pollingLoopAsync(context, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).takeUntil(apr -> PollingUtil.matchStatus(apr, statusToWaitFor)).last().map(response -> {
            if (response.getStatus().isComplete()) {
                this.terminalPollContext = context;
            }
            return PollingUtil.toPollResponse(response);
        }).block();
    }

    @Override
    public PollResponse<T> waitUntil(Duration timeout2, LongRunningOperationStatus statusToWaitFor) {
        PollingUtil.validateTimeout(timeout2, LOGGER);
        Objects.requireNonNull(statusToWaitFor, "'statusToWaitFor' cannot be null.");
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        return PollingUtil.pollingLoopAsync(context, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).take(timeout2).takeUntil(apr -> PollingUtil.matchStatus(apr, statusToWaitFor)).takeLast(1).flatMap(response -> {
            if (response.getStatus().isComplete()) {
                this.terminalPollContext = context;
            }
            return Mono.just(PollingUtil.toPollResponse(response));
        }).switchIfEmpty(Mono.fromCallable(this.pollingContext::getLatestResponse)).blockLast();
    }

    @Override
    public U getFinalResult() {
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return this.fetchResultOperation.apply(currentTerminalPollContext).block();
        }
        PollingContext<T> context = this.pollingContext.copy();
        return (U)PollingUtil.pollingLoopAsync(context, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).last().flatMap(response -> {
            this.terminalPollContext = context;
            return response.getFinalResult();
        }).block();
    }

    @Override
    public U getFinalResult(Duration timeout2) {
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return this.fetchResultOperation.apply(currentTerminalPollContext).block();
        }
        PollingContext<T> context = this.pollingContext.copy();
        return (U)PollingUtil.pollingLoopAsync(context, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).take(timeout2).switchIfEmpty(Mono.error(() -> new TimeoutException("Polling didn't complete before the timeout period."))).last().flatMap(response -> {
            if (response != null && response.getStatus().isComplete()) {
                this.terminalPollContext = context;
                return response.getFinalResult();
            }
            return Mono.error(new TimeoutException("Polling didn't complete before the timeout period."));
        }).block();
    }

    @Override
    public void cancelOperation() {
        PollingContext<T> context1 = this.pollingContext.copy();
        if (context1.getActivationResponse() == context1.getLatestResponse()) {
            this.cancelOperation.apply(context1, context1.getActivationResponse()).block();
        } else {
            this.cancelOperation.apply(null, this.activationResponse).onErrorResume(PollContextRequiredException.class, crp -> {
                PollingContext<T> context2 = this.pollingContext.copy();
                return PollingUtil.pollingLoopAsync(context2, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).next().then(this.cancelOperation.apply(context2, this.activationResponse));
            }).block();
        }
    }

    @Override
    public SyncPoller<T, U> setPollInterval(Duration pollInterval) {
        this.pollInterval = PollingUtil.validatePollInterval(pollInterval, LOGGER);
        return this;
    }
}

