/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialUnavailableException;
import com.dataiku.dss.shadelibazure.com.azure.identity.InteractiveBrowserCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.IdentityUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.concurrent.atomic.AtomicReference;

class BrokerCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(BrokerCredential.class);
    private static final String BROKER_BUILDER_CLASS = "com.dataiku.dss.shadelibazure.com.azure.identity.broker.InteractiveBrowserBrokerCredentialBuilder";
    private final String tenantId;
    private final AtomicReference<TokenCredential> cached = new AtomicReference();

    BrokerCredential(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        TokenCredential credential = this.cached.get();
        if (credential == null) {
            TokenCredential newCredential;
            try {
                newCredential = this.createBrokerCredential();
            }
            catch (CredentialUnavailableException e) {
                return Mono.error(e);
            }
            catch (Exception e) {
                return Mono.error(LOGGER.logExceptionAsError(new CredentialUnavailableException("Failed to create OS Broker credential.", (Throwable)e)));
            }
            credential = this.cached.compareAndSet(null, newCredential) ? newCredential : this.cached.get();
        }
        return credential.getToken(request);
    }

    private TokenCredential createBrokerCredential() {
        String troubleshoot = " To mitigate this issue, refer to http://aka.ms/azsdk/java/identity/dacbrokerauth/troubleshoot";
        if (!IdentityUtil.isBrokerAvailable()) {
            throw LOGGER.logExceptionAsError(new CredentialUnavailableException("azure-identity-broker dependency is not available. Ensure you have azure-identity-broker dependency added to your application. To mitigate this issue, refer to http://aka.ms/azsdk/java/identity/dacbrokerauth/troubleshoot"));
        }
        try {
            Class<?> builderClass = Class.forName(BROKER_BUILDER_CLASS);
            Object builder = builderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            builderClass.getMethod("setWindowHandle", Long.TYPE).invoke(builder, 0);
            builderClass.getMethod("useDefaultBrokerAccount", new Class[0]).invoke(builder, new Object[0]);
            InteractiveBrowserCredentialBuilder browserCredentialBuilder = (InteractiveBrowserCredentialBuilder)builder;
            if (!CoreUtils.isNullOrEmpty(this.tenantId)) {
                builderClass.getMethod("tenantId", String.class).invoke(builder, this.tenantId);
            }
            return browserCredentialBuilder.build();
        }
        catch (ClassNotFoundException e) {
            throw LOGGER.logExceptionAsError(new CredentialUnavailableException("InteractiveBrowserBrokerCredentialBuilder class not found. Ensure you have azure-identity-broker dependency added to your application. To mitigate this issue, refer to http://aka.ms/azsdk/java/identity/dacbrokerauth/troubleshoot", (Throwable)e));
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError(new CredentialUnavailableException("Failed to create InteractiveBrowserBrokerCredential dynamically. To mitigate this issue, refer to http://aka.ms/azsdk/java/identity/dacbrokerauth/troubleshoot", (Throwable)e));
        }
    }
}

