/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.AuthenticationRecord;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialUnavailableException;
import com.dataiku.dss.shadelibazure.com.azure.identity.InteractiveBrowserCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.IdentityUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.LoggingUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class VisualStudioCodeCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(VisualStudioCodeCredential.class);
    private static final String VSCODE_CLIENT_ID = "aebc6443-996d-45c2-90f0-388ff96faa56";
    private static final String BROKER_BUILDER_CLASS = "com.dataiku.dss.shadelibazure.com.azure.identity.broker.InteractiveBrowserBrokerCredentialBuilder";
    private final IdentityClientOptions clientOptions;
    private final String tenant;

    VisualStudioCodeCredential(String tenantId, IdentityClientOptions identityClientOptions) {
        this.clientOptions = identityClientOptions == null ? new IdentityClientOptions() : identityClientOptions;
        this.tenant = !CoreUtils.isNullOrEmpty(tenantId) ? tenantId : null;
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            TokenCredential brokerAuthCredential = this.getBrokerAuthCredential(VSCODE_CLIENT_ID);
            if (brokerAuthCredential != null) {
                return brokerAuthCredential.getToken(request);
            }
            return Mono.error(new CredentialUnavailableException("Visual Studio Code Authentication is not available. Ensure you have azure-identity-broker dependency added to your application. Then ensure, you have signed into Azure via VS Code and have Azure Resources Extension installed in VS Code. For more details, refer to https://aka.ms/azsdk/java/identity/vscodecredential/troubleshoot"));
        }).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.clientOptions, request, error));
    }

    TokenCredential getBrokerAuthCredential(String clientId) {
        if (!IdentityUtil.isVsCodeBrokerAuthAvailable()) {
            return null;
        }
        try {
            Class<?> builderClass = Class.forName(BROKER_BUILDER_CLASS);
            Object builder = builderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            AuthenticationRecord authenticationRecord = IdentityUtil.loadVSCodeAuthRecord();
            builderClass.getMethod("setWindowHandle", Long.TYPE).invoke(builder, 0);
            InteractiveBrowserCredentialBuilder browserCredentialBuilder = (InteractiveBrowserCredentialBuilder)builder;
            browserCredentialBuilder.clientId(clientId);
            browserCredentialBuilder.authenticationRecord(authenticationRecord);
            if (CoreUtils.isNullOrEmpty(this.tenant)) {
                builderClass.getMethod("tenantId", String.class).invoke(builder, authenticationRecord.getTenantId());
            } else {
                builderClass.getMethod("tenantId", String.class).invoke(builder, this.tenant);
            }
            return browserCredentialBuilder.build();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError(new CredentialUnavailableException("Failed to create VisualStudioCodeCredential dynamically", (Throwable)e));
        }
    }
}

