/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.ApplicationLiveViewsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.ApplicationLiveViewResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ApplicationLiveViewResourceCollection;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class ApplicationLiveViewsClientImpl
implements ApplicationLiveViewsClient {
    private final ApplicationLiveViewsService service;
    private final AppPlatformManagementClientImpl client;

    ApplicationLiveViewsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = RestProxy.create(ApplicationLiveViewsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationLiveViewResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApplicationLiveViewResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationLiveViewResourceCollection)res.getValue()).value(), ((ApplicationLiveViewResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationLiveViewResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", context).map(res -> new PagedResponseBase<Object, ApplicationLiveViewResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationLiveViewResourceCollection)res.getValue()).value(), ((ApplicationLiveViewResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApplicationLiveViewResourceInner> listAsync(String resourceGroupName, String serviceName) {
        return new PagedFlux<ApplicationLiveViewResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApplicationLiveViewResourceInner> listAsync(String resourceGroupName, String serviceName, Context context) {
        return new PagedFlux<ApplicationLiveViewResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApplicationLiveViewResourceInner> list(String resourceGroupName, String serviceName) {
        return new PagedIterable<ApplicationLiveViewResourceInner>(this.listAsync(resourceGroupName, serviceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApplicationLiveViewResourceInner> list(String resourceGroupName, String serviceName, Context context) {
        return new PagedIterable<ApplicationLiveViewResourceInner>(this.listAsync(resourceGroupName, serviceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApplicationLiveViewResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String applicationLiveViewName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationLiveViewName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationLiveViewName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationLiveViewName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationLiveViewResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationLiveViewName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationLiveViewName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationLiveViewName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApplicationLiveViewResourceInner> getAsync(String resourceGroupName, String serviceName, String applicationLiveViewName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, applicationLiveViewName).flatMap(res -> Mono.justOrEmpty((ApplicationLiveViewResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApplicationLiveViewResourceInner> getWithResponse(String resourceGroupName, String serviceName, String applicationLiveViewName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, applicationLiveViewName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationLiveViewResourceInner get(String resourceGroupName, String serviceName, String applicationLiveViewName) {
        return this.getWithResponse(resourceGroupName, serviceName, applicationLiveViewName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationLiveViewName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationLiveViewName is required and cannot be null."));
        }
        if (applicationLiveViewResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationLiveViewResource is required and cannot be null."));
        }
        applicationLiveViewResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationLiveViewName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationLiveViewName is required and cannot be null."));
        }
        if (applicationLiveViewResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationLiveViewResource is required and cannot be null."));
        }
        applicationLiveViewResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ApplicationLiveViewResourceInner>, ApplicationLiveViewResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ApplicationLiveViewResourceInner.class), (Type)((Object)ApplicationLiveViewResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ApplicationLiveViewResourceInner>, ApplicationLiveViewResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ApplicationLiveViewResourceInner.class), (Type)((Object)ApplicationLiveViewResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApplicationLiveViewResourceInner>, ApplicationLiveViewResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApplicationLiveViewResourceInner>, ApplicationLiveViewResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApplicationLiveViewResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApplicationLiveViewResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationLiveViewResourceInner createOrUpdate(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationLiveViewResourceInner createOrUpdate(String resourceGroupName, String serviceName, String applicationLiveViewName, ApplicationLiveViewResourceInner applicationLiveViewResource, Context context) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, applicationLiveViewName, applicationLiveViewResource, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String applicationLiveViewName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationLiveViewName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationLiveViewName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationLiveViewName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationLiveViewName == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationLiveViewName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationLiveViewName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String applicationLiveViewName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, applicationLiveViewName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, applicationLiveViewName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String applicationLiveViewName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, applicationLiveViewName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String applicationLiveViewName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, applicationLiveViewName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String applicationLiveViewName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, applicationLiveViewName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String applicationLiveViewName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, applicationLiveViewName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String applicationLiveViewName) {
        this.deleteAsync(resourceGroupName, serviceName, applicationLiveViewName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String applicationLiveViewName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, applicationLiveViewName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationLiveViewResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApplicationLiveViewResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationLiveViewResourceCollection)res.getValue()).value(), ((ApplicationLiveViewResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationLiveViewResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ApplicationLiveViewResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationLiveViewResourceCollection)res.getValue()).value(), ((ApplicationLiveViewResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface ApplicationLiveViewsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationLiveViews")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationLiveViewResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationLiveViews/{applicationLiveViewName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationLiveViewResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="applicationLiveViewName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationLiveViews/{applicationLiveViewName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="applicationLiveViewName") String var6, @BodyParam(value="application/json") ApplicationLiveViewResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationLiveViews/{applicationLiveViewName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="applicationLiveViewName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationLiveViewResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

