/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ApmReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.BuildProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.BuildResourceRequests;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.CertificateReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.TriggeredBuildResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BuildProperties
implements JsonSerializable<BuildProperties> {
    private String relativePath;
    private String builder;
    private String agentPool;
    private BuildProvisioningState provisioningState;
    private Map<String, String> env;
    private List<ApmReference> apms;
    private List<CertificateReference> certificates;
    private TriggeredBuildResult triggeredBuildResult;
    private BuildResourceRequests resourceRequests;

    public String relativePath() {
        return this.relativePath;
    }

    public BuildProperties withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public String builder() {
        return this.builder;
    }

    public BuildProperties withBuilder(String builder) {
        this.builder = builder;
        return this;
    }

    public String agentPool() {
        return this.agentPool;
    }

    public BuildProperties withAgentPool(String agentPool) {
        this.agentPool = agentPool;
        return this;
    }

    public BuildProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Map<String, String> env() {
        return this.env;
    }

    public BuildProperties withEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public List<ApmReference> apms() {
        return this.apms;
    }

    public BuildProperties withApms(List<ApmReference> apms) {
        this.apms = apms;
        return this;
    }

    public List<CertificateReference> certificates() {
        return this.certificates;
    }

    public BuildProperties withCertificates(List<CertificateReference> certificates) {
        this.certificates = certificates;
        return this;
    }

    public TriggeredBuildResult triggeredBuildResult() {
        return this.triggeredBuildResult;
    }

    public BuildResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public BuildProperties withResourceRequests(BuildResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    public void validate() {
        if (this.apms() != null) {
            this.apms().forEach(e -> e.validate());
        }
        if (this.certificates() != null) {
            this.certificates().forEach(e -> e.validate());
        }
        if (this.triggeredBuildResult() != null) {
            this.triggeredBuildResult().validate();
        }
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("relativePath", this.relativePath);
        jsonWriter.writeStringField("builder", this.builder);
        jsonWriter.writeStringField("agentPool", this.agentPool);
        jsonWriter.writeMapField("env", this.env, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("apms", this.apms, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("resourceRequests", this.resourceRequests);
        return jsonWriter.writeEndObject();
    }

    public static BuildProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildProperties deserializedBuildProperties = new BuildProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("relativePath".equals(fieldName)) {
                    deserializedBuildProperties.relativePath = reader.getString();
                    continue;
                }
                if ("builder".equals(fieldName)) {
                    deserializedBuildProperties.builder = reader.getString();
                    continue;
                }
                if ("agentPool".equals(fieldName)) {
                    deserializedBuildProperties.agentPool = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBuildProperties.provisioningState = BuildProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("env".equals(fieldName)) {
                    Map<String, String> env = reader.readMap(reader1 -> reader1.getString());
                    deserializedBuildProperties.env = env;
                    continue;
                }
                if ("apms".equals(fieldName)) {
                    List<ApmReference> apms = reader.readArray(reader1 -> ApmReference.fromJson(reader1));
                    deserializedBuildProperties.apms = apms;
                    continue;
                }
                if ("certificates".equals(fieldName)) {
                    List<CertificateReference> certificates = reader.readArray(reader1 -> CertificateReference.fromJson(reader1));
                    deserializedBuildProperties.certificates = certificates;
                    continue;
                }
                if ("triggeredBuildResult".equals(fieldName)) {
                    deserializedBuildProperties.triggeredBuildResult = TriggeredBuildResult.fromJson(reader);
                    continue;
                }
                if ("resourceRequests".equals(fieldName)) {
                    deserializedBuildProperties.resourceRequests = BuildResourceRequests.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuildProperties;
        });
    }
}

