/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.IngressConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.NetworkProfileOutboundIPs;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.RequiredTraffic;
import java.io.IOException;
import java.util.List;

public final class NetworkProfile
implements JsonSerializable<NetworkProfile> {
    private String serviceRuntimeSubnetId;
    private String appSubnetId;
    private String serviceCidr;
    private String serviceRuntimeNetworkResourceGroup;
    private String appNetworkResourceGroup;
    private NetworkProfileOutboundIPs outboundIPs;
    private List<RequiredTraffic> requiredTraffics;
    private IngressConfig ingressConfig;
    private String outboundType;

    public String serviceRuntimeSubnetId() {
        return this.serviceRuntimeSubnetId;
    }

    public NetworkProfile withServiceRuntimeSubnetId(String serviceRuntimeSubnetId) {
        this.serviceRuntimeSubnetId = serviceRuntimeSubnetId;
        return this;
    }

    public String appSubnetId() {
        return this.appSubnetId;
    }

    public NetworkProfile withAppSubnetId(String appSubnetId) {
        this.appSubnetId = appSubnetId;
        return this;
    }

    public String serviceCidr() {
        return this.serviceCidr;
    }

    public NetworkProfile withServiceCidr(String serviceCidr) {
        this.serviceCidr = serviceCidr;
        return this;
    }

    public String serviceRuntimeNetworkResourceGroup() {
        return this.serviceRuntimeNetworkResourceGroup;
    }

    public NetworkProfile withServiceRuntimeNetworkResourceGroup(String serviceRuntimeNetworkResourceGroup) {
        this.serviceRuntimeNetworkResourceGroup = serviceRuntimeNetworkResourceGroup;
        return this;
    }

    public String appNetworkResourceGroup() {
        return this.appNetworkResourceGroup;
    }

    public NetworkProfile withAppNetworkResourceGroup(String appNetworkResourceGroup) {
        this.appNetworkResourceGroup = appNetworkResourceGroup;
        return this;
    }

    public NetworkProfileOutboundIPs outboundIPs() {
        return this.outboundIPs;
    }

    public List<RequiredTraffic> requiredTraffics() {
        return this.requiredTraffics;
    }

    public IngressConfig ingressConfig() {
        return this.ingressConfig;
    }

    public NetworkProfile withIngressConfig(IngressConfig ingressConfig) {
        this.ingressConfig = ingressConfig;
        return this;
    }

    public String outboundType() {
        return this.outboundType;
    }

    public NetworkProfile withOutboundType(String outboundType) {
        this.outboundType = outboundType;
        return this;
    }

    public void validate() {
        if (this.outboundIPs() != null) {
            this.outboundIPs().validate();
        }
        if (this.requiredTraffics() != null) {
            this.requiredTraffics().forEach(e -> e.validate());
        }
        if (this.ingressConfig() != null) {
            this.ingressConfig().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceRuntimeSubnetId", this.serviceRuntimeSubnetId);
        jsonWriter.writeStringField("appSubnetId", this.appSubnetId);
        jsonWriter.writeStringField("serviceCidr", this.serviceCidr);
        jsonWriter.writeStringField("serviceRuntimeNetworkResourceGroup", this.serviceRuntimeNetworkResourceGroup);
        jsonWriter.writeStringField("appNetworkResourceGroup", this.appNetworkResourceGroup);
        jsonWriter.writeJsonField("ingressConfig", this.ingressConfig);
        jsonWriter.writeStringField("outboundType", this.outboundType);
        return jsonWriter.writeEndObject();
    }

    public static NetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkProfile deserializedNetworkProfile = new NetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceRuntimeSubnetId".equals(fieldName)) {
                    deserializedNetworkProfile.serviceRuntimeSubnetId = reader.getString();
                    continue;
                }
                if ("appSubnetId".equals(fieldName)) {
                    deserializedNetworkProfile.appSubnetId = reader.getString();
                    continue;
                }
                if ("serviceCidr".equals(fieldName)) {
                    deserializedNetworkProfile.serviceCidr = reader.getString();
                    continue;
                }
                if ("serviceRuntimeNetworkResourceGroup".equals(fieldName)) {
                    deserializedNetworkProfile.serviceRuntimeNetworkResourceGroup = reader.getString();
                    continue;
                }
                if ("appNetworkResourceGroup".equals(fieldName)) {
                    deserializedNetworkProfile.appNetworkResourceGroup = reader.getString();
                    continue;
                }
                if ("outboundIPs".equals(fieldName)) {
                    deserializedNetworkProfile.outboundIPs = NetworkProfileOutboundIPs.fromJson(reader);
                    continue;
                }
                if ("requiredTraffics".equals(fieldName)) {
                    List<RequiredTraffic> requiredTraffics = reader.readArray(reader1 -> RequiredTraffic.fromJson(reader1));
                    deserializedNetworkProfile.requiredTraffics = requiredTraffics;
                    continue;
                }
                if ("ingressConfig".equals(fieldName)) {
                    deserializedNetworkProfile.ingressConfig = IngressConfig.fromJson(reader);
                    continue;
                }
                if ("outboundType".equals(fieldName)) {
                    deserializedNetworkProfile.outboundType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkProfile;
        });
    }
}

