/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CertificateProperties
implements JsonSerializable<CertificateProperties> {
    private String password;
    private String friendlyName;
    private String subjectName;
    private List<String> hostNames;
    private byte[] pfxBlob;
    private String siteName;
    private String selfLink;
    private String issuer;
    private OffsetDateTime issueDate;
    private OffsetDateTime expirationDate;
    private String thumbprint;
    private Boolean valid;
    private byte[] cerBlob;
    private String publicKeyHash;
    private HostingEnvironmentProfile hostingEnvironmentProfile;
    private String keyVaultId;
    private String keyVaultSecretName;
    private KeyVaultSecretStatus keyVaultSecretStatus;
    private String serverFarmId;
    private String canonicalName;
    private String domainValidationMethod;

    public String password() {
        return this.password;
    }

    public CertificateProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public String friendlyName() {
        return this.friendlyName;
    }

    public String subjectName() {
        return this.subjectName;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public CertificateProperties withHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public byte[] pfxBlob() {
        return CoreUtils.clone(this.pfxBlob);
    }

    public CertificateProperties withPfxBlob(byte[] pfxBlob) {
        this.pfxBlob = CoreUtils.clone(pfxBlob);
        return this;
    }

    public String siteName() {
        return this.siteName;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public String issuer() {
        return this.issuer;
    }

    public OffsetDateTime issueDate() {
        return this.issueDate;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Boolean valid() {
        return this.valid;
    }

    public byte[] cerBlob() {
        return CoreUtils.clone(this.cerBlob);
    }

    public String publicKeyHash() {
        return this.publicKeyHash;
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.hostingEnvironmentProfile;
    }

    public String keyVaultId() {
        return this.keyVaultId;
    }

    public CertificateProperties withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    public String keyVaultSecretName() {
        return this.keyVaultSecretName;
    }

    public CertificateProperties withKeyVaultSecretName(String keyVaultSecretName) {
        this.keyVaultSecretName = keyVaultSecretName;
        return this;
    }

    public KeyVaultSecretStatus keyVaultSecretStatus() {
        return this.keyVaultSecretStatus;
    }

    public String serverFarmId() {
        return this.serverFarmId;
    }

    public CertificateProperties withServerFarmId(String serverFarmId) {
        this.serverFarmId = serverFarmId;
        return this;
    }

    public String canonicalName() {
        return this.canonicalName;
    }

    public CertificateProperties withCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
        return this;
    }

    public String domainValidationMethod() {
        return this.domainValidationMethod;
    }

    public CertificateProperties withDomainValidationMethod(String domainValidationMethod) {
        this.domainValidationMethod = domainValidationMethod;
        return this;
    }

    public void validate() {
        if (this.hostingEnvironmentProfile() != null) {
            this.hostingEnvironmentProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeArrayField("hostNames", this.hostNames, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBinaryField("pfxBlob", this.pfxBlob);
        jsonWriter.writeStringField("keyVaultId", this.keyVaultId);
        jsonWriter.writeStringField("keyVaultSecretName", this.keyVaultSecretName);
        jsonWriter.writeStringField("serverFarmId", this.serverFarmId);
        jsonWriter.writeStringField("canonicalName", this.canonicalName);
        jsonWriter.writeStringField("domainValidationMethod", this.domainValidationMethod);
        return jsonWriter.writeEndObject();
    }

    public static CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateProperties deserializedCertificateProperties = new CertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("password".equals(fieldName)) {
                    deserializedCertificateProperties.password = reader.getString();
                    continue;
                }
                if ("friendlyName".equals(fieldName)) {
                    deserializedCertificateProperties.friendlyName = reader.getString();
                    continue;
                }
                if ("subjectName".equals(fieldName)) {
                    deserializedCertificateProperties.subjectName = reader.getString();
                    continue;
                }
                if ("hostNames".equals(fieldName)) {
                    List<String> hostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedCertificateProperties.hostNames = hostNames;
                    continue;
                }
                if ("pfxBlob".equals(fieldName)) {
                    deserializedCertificateProperties.pfxBlob = reader.getBinary();
                    continue;
                }
                if ("siteName".equals(fieldName)) {
                    deserializedCertificateProperties.siteName = reader.getString();
                    continue;
                }
                if ("selfLink".equals(fieldName)) {
                    deserializedCertificateProperties.selfLink = reader.getString();
                    continue;
                }
                if ("issuer".equals(fieldName)) {
                    deserializedCertificateProperties.issuer = reader.getString();
                    continue;
                }
                if ("issueDate".equals(fieldName)) {
                    deserializedCertificateProperties.issueDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedCertificateProperties.expirationDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("valid".equals(fieldName)) {
                    deserializedCertificateProperties.valid = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("cerBlob".equals(fieldName)) {
                    deserializedCertificateProperties.cerBlob = reader.getBinary();
                    continue;
                }
                if ("publicKeyHash".equals(fieldName)) {
                    deserializedCertificateProperties.publicKeyHash = reader.getString();
                    continue;
                }
                if ("hostingEnvironmentProfile".equals(fieldName)) {
                    deserializedCertificateProperties.hostingEnvironmentProfile = HostingEnvironmentProfile.fromJson(reader);
                    continue;
                }
                if ("keyVaultId".equals(fieldName)) {
                    deserializedCertificateProperties.keyVaultId = reader.getString();
                    continue;
                }
                if ("keyVaultSecretName".equals(fieldName)) {
                    deserializedCertificateProperties.keyVaultSecretName = reader.getString();
                    continue;
                }
                if ("keyVaultSecretStatus".equals(fieldName)) {
                    deserializedCertificateProperties.keyVaultSecretStatus = KeyVaultSecretStatus.fromString(reader.getString());
                    continue;
                }
                if ("serverFarmId".equals(fieldName)) {
                    deserializedCertificateProperties.serverFarmId = reader.getString();
                    continue;
                }
                if ("canonicalName".equals(fieldName)) {
                    deserializedCertificateProperties.canonicalName = reader.getString();
                    continue;
                }
                if ("domainValidationMethod".equals(fieldName)) {
                    deserializedCertificateProperties.domainValidationMethod = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateProperties;
        });
    }
}

