/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.StaticSiteDatabaseConnectionConfigurationFileOverview;
import java.io.IOException;
import java.util.List;

public final class DatabaseConnectionProperties
implements JsonSerializable<DatabaseConnectionProperties> {
    private String resourceId;
    private String connectionIdentity;
    private String connectionString;
    private String region;
    private List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseConnectionProperties.class);

    public String resourceId() {
        return this.resourceId;
    }

    public DatabaseConnectionProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String connectionIdentity() {
        return this.connectionIdentity;
    }

    public DatabaseConnectionProperties withConnectionIdentity(String connectionIdentity) {
        this.connectionIdentity = connectionIdentity;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public DatabaseConnectionProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String region() {
        return this.region;
    }

    public DatabaseConnectionProperties withRegion(String region) {
        this.region = region;
        return this;
    }

    public List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles() {
        return this.configurationFiles;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property resourceId in model DatabaseConnectionProperties"));
        }
        if (this.region() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property region in model DatabaseConnectionProperties"));
        }
        if (this.configurationFiles() != null) {
            this.configurationFiles().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("connectionIdentity", this.connectionIdentity);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseConnectionProperties deserializedDatabaseConnectionProperties = new DatabaseConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedDatabaseConnectionProperties.resourceId = reader.getString();
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedDatabaseConnectionProperties.region = reader.getString();
                    continue;
                }
                if ("connectionIdentity".equals(fieldName)) {
                    deserializedDatabaseConnectionProperties.connectionIdentity = reader.getString();
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedDatabaseConnectionProperties.connectionString = reader.getString();
                    continue;
                }
                if ("configurationFiles".equals(fieldName)) {
                    List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles = reader.readArray(reader1 -> StaticSiteDatabaseConnectionConfigurationFileOverview.fromJson(reader1));
                    deserializedDatabaseConnectionProperties.configurationFiles = configurationFiles;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseConnectionProperties;
        });
    }
}

