/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RevisionHealthState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RevisionProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Template;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RevisionProperties
implements JsonSerializable<RevisionProperties> {
    private OffsetDateTime createdTime;
    private String fqdn;
    private Template template;
    private Boolean active;
    private Integer replicas;
    private Integer trafficWeight;
    private String provisioningError;
    private RevisionHealthState healthState;
    private RevisionProvisioningState provisioningState;

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public Template template() {
        return this.template;
    }

    public Boolean active() {
        return this.active;
    }

    public Integer replicas() {
        return this.replicas;
    }

    public Integer trafficWeight() {
        return this.trafficWeight;
    }

    public String provisioningError() {
        return this.provisioningError;
    }

    public RevisionHealthState healthState() {
        return this.healthState;
    }

    public RevisionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.template() != null) {
            this.template().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RevisionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RevisionProperties deserializedRevisionProperties = new RevisionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdTime".equals(fieldName)) {
                    deserializedRevisionProperties.createdTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedRevisionProperties.fqdn = reader.getString();
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedRevisionProperties.template = Template.fromJson(reader);
                    continue;
                }
                if ("active".equals(fieldName)) {
                    deserializedRevisionProperties.active = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("replicas".equals(fieldName)) {
                    deserializedRevisionProperties.replicas = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("trafficWeight".equals(fieldName)) {
                    deserializedRevisionProperties.trafficWeight = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisioningError".equals(fieldName)) {
                    deserializedRevisionProperties.provisioningError = reader.getString();
                    continue;
                }
                if ("healthState".equals(fieldName)) {
                    deserializedRevisionProperties.healthState = RevisionHealthState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRevisionProperties.provisioningState = RevisionProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRevisionProperties;
        });
    }
}

