/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ContentLink;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RetryHistory;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RunActionCorrelation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class WorkflowRunActionProperties
implements JsonSerializable<WorkflowRunActionProperties> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private WorkflowStatus status;
    private String code;
    private Object error;
    private String trackingId;
    private RunActionCorrelation correlation;
    private ContentLink inputsLink;
    private ContentLink outputsLink;
    private Object trackedProperties;
    private List<RetryHistory> retryHistory;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public WorkflowStatus status() {
        return this.status;
    }

    public String code() {
        return this.code;
    }

    public Object error() {
        return this.error;
    }

    public String trackingId() {
        return this.trackingId;
    }

    public RunActionCorrelation correlation() {
        return this.correlation;
    }

    public WorkflowRunActionProperties withCorrelation(RunActionCorrelation correlation) {
        this.correlation = correlation;
        return this;
    }

    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    public Object trackedProperties() {
        return this.trackedProperties;
    }

    public List<RetryHistory> retryHistory() {
        return this.retryHistory;
    }

    public WorkflowRunActionProperties withRetryHistory(List<RetryHistory> retryHistory) {
        this.retryHistory = retryHistory;
        return this;
    }

    public void validate() {
        if (this.correlation() != null) {
            this.correlation().validate();
        }
        if (this.inputsLink() != null) {
            this.inputsLink().validate();
        }
        if (this.outputsLink() != null) {
            this.outputsLink().validate();
        }
        if (this.retryHistory() != null) {
            this.retryHistory().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("correlation", this.correlation);
        jsonWriter.writeArrayField("retryHistory", this.retryHistory, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static WorkflowRunActionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowRunActionProperties deserializedWorkflowRunActionProperties = new WorkflowRunActionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.status = WorkflowStatus.fromString(reader.getString());
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.code = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.error = reader.readUntyped();
                    continue;
                }
                if ("trackingId".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.trackingId = reader.getString();
                    continue;
                }
                if ("correlation".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.correlation = RunActionCorrelation.fromJson(reader);
                    continue;
                }
                if ("inputsLink".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.inputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("outputsLink".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.outputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("trackedProperties".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.trackedProperties = reader.readUntyped();
                    continue;
                }
                if ("retryHistory".equals(fieldName)) {
                    List<RetryHistory> retryHistory = reader.readArray(reader1 -> RetryHistory.fromJson(reader1));
                    deserializedWorkflowRunActionProperties.retryHistory = retryHistory;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowRunActionProperties;
        });
    }
}

