/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Correlation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WorkflowOutputParameter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WorkflowRunTrigger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WorkflowRunProperties
implements JsonSerializable<WorkflowRunProperties> {
    private OffsetDateTime waitEndTime;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private WorkflowStatus status;
    private String code;
    private Object error;
    private String correlationId;
    private Correlation correlation;
    private ResourceReference workflow;
    private WorkflowRunTrigger trigger;
    private Map<String, WorkflowOutputParameter> outputs;
    private WorkflowRunTrigger response;

    public OffsetDateTime waitEndTime() {
        return this.waitEndTime;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public WorkflowStatus status() {
        return this.status;
    }

    public String code() {
        return this.code;
    }

    public Object error() {
        return this.error;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public Correlation correlation() {
        return this.correlation;
    }

    public WorkflowRunProperties withCorrelation(Correlation correlation) {
        this.correlation = correlation;
        return this;
    }

    public ResourceReference workflow() {
        return this.workflow;
    }

    public WorkflowRunTrigger trigger() {
        return this.trigger;
    }

    public Map<String, WorkflowOutputParameter> outputs() {
        return this.outputs;
    }

    public WorkflowRunTrigger response() {
        return this.response;
    }

    public void validate() {
        if (this.correlation() != null) {
            this.correlation().validate();
        }
        if (this.workflow() != null) {
            this.workflow().validate();
        }
        if (this.trigger() != null) {
            this.trigger().validate();
        }
        if (this.outputs() != null) {
            this.outputs().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.response() != null) {
            this.response().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("correlation", this.correlation);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowRunProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowRunProperties deserializedWorkflowRunProperties = new WorkflowRunProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("waitEndTime".equals(fieldName)) {
                    deserializedWorkflowRunProperties.waitEndTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedWorkflowRunProperties.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedWorkflowRunProperties.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWorkflowRunProperties.status = WorkflowStatus.fromString(reader.getString());
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedWorkflowRunProperties.code = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedWorkflowRunProperties.error = reader.readUntyped();
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedWorkflowRunProperties.correlationId = reader.getString();
                    continue;
                }
                if ("correlation".equals(fieldName)) {
                    deserializedWorkflowRunProperties.correlation = Correlation.fromJson(reader);
                    continue;
                }
                if ("workflow".equals(fieldName)) {
                    deserializedWorkflowRunProperties.workflow = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("trigger".equals(fieldName)) {
                    deserializedWorkflowRunProperties.trigger = WorkflowRunTrigger.fromJson(reader);
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    Map<String, WorkflowOutputParameter> outputs = reader.readMap(reader1 -> WorkflowOutputParameter.fromJson(reader1));
                    deserializedWorkflowRunProperties.outputs = outputs;
                    continue;
                }
                if ("response".equals(fieldName)) {
                    deserializedWorkflowRunProperties.response = WorkflowRunTrigger.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowRunProperties;
        });
    }
}

