/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ConnectionStringType;
import java.io.IOException;

public final class ConnStringValueTypePair
implements JsonSerializable<ConnStringValueTypePair> {
    private String value;
    private ConnectionStringType type;
    private static final ClientLogger LOGGER = new ClientLogger(ConnStringValueTypePair.class);

    public String value() {
        return this.value;
    }

    public ConnStringValueTypePair withValue(String value) {
        this.value = value;
        return this;
    }

    public ConnectionStringType type() {
        return this.type;
    }

    public ConnStringValueTypePair withType(ConnectionStringType type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property value in model ConnStringValueTypePair"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model ConnStringValueTypePair"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ConnStringValueTypePair fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnStringValueTypePair deserializedConnStringValueTypePair = new ConnStringValueTypePair();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedConnStringValueTypePair.value = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConnStringValueTypePair.type = ConnectionStringType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnStringValueTypePair;
        });
    }
}

