/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.OpenIdConnectLogin;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.OpenIdConnectRegistration;
import java.io.IOException;

public final class CustomOpenIdConnectProvider
implements JsonSerializable<CustomOpenIdConnectProvider> {
    private Boolean enabled;
    private OpenIdConnectRegistration registration;
    private OpenIdConnectLogin login;

    public Boolean enabled() {
        return this.enabled;
    }

    public CustomOpenIdConnectProvider withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OpenIdConnectRegistration registration() {
        return this.registration;
    }

    public CustomOpenIdConnectProvider withRegistration(OpenIdConnectRegistration registration) {
        this.registration = registration;
        return this;
    }

    public OpenIdConnectLogin login() {
        return this.login;
    }

    public CustomOpenIdConnectProvider withLogin(OpenIdConnectLogin login) {
        this.login = login;
        return this;
    }

    public void validate() {
        if (this.registration() != null) {
            this.registration().validate();
        }
        if (this.login() != null) {
            this.login().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("registration", this.registration);
        jsonWriter.writeJsonField("login", this.login);
        return jsonWriter.writeEndObject();
    }

    public static CustomOpenIdConnectProvider fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomOpenIdConnectProvider deserializedCustomOpenIdConnectProvider = new CustomOpenIdConnectProvider();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedCustomOpenIdConnectProvider.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("registration".equals(fieldName)) {
                    deserializedCustomOpenIdConnectProvider.registration = OpenIdConnectRegistration.fromJson(reader);
                    continue;
                }
                if ("login".equals(fieldName)) {
                    deserializedCustomOpenIdConnectProvider.login = OpenIdConnectLogin.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomOpenIdConnectProvider;
        });
    }
}

