/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DataTableResponseColumn;
import java.io.IOException;
import java.util.List;

public final class DataTableResponseObject
implements JsonSerializable<DataTableResponseObject> {
    private String tableName;
    private List<DataTableResponseColumn> columns;
    private List<List<String>> rows;

    public String tableName() {
        return this.tableName;
    }

    public DataTableResponseObject withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<DataTableResponseColumn> columns() {
        return this.columns;
    }

    public DataTableResponseObject withColumns(List<DataTableResponseColumn> columns) {
        this.columns = columns;
        return this;
    }

    public List<List<String>> rows() {
        return this.rows;
    }

    public DataTableResponseObject withRows(List<List<String>> rows) {
        this.rows = rows;
        return this;
    }

    public void validate() {
        if (this.columns() != null) {
            this.columns().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tableName", this.tableName);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("rows", this.rows, (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeString((String)element1)));
        return jsonWriter.writeEndObject();
    }

    public static DataTableResponseObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataTableResponseObject deserializedDataTableResponseObject = new DataTableResponseObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tableName".equals(fieldName)) {
                    deserializedDataTableResponseObject.tableName = reader.getString();
                    continue;
                }
                if ("columns".equals(fieldName)) {
                    List<DataTableResponseColumn> columns = reader.readArray(reader1 -> DataTableResponseColumn.fromJson(reader1));
                    deserializedDataTableResponseObject.columns = columns;
                    continue;
                }
                if ("rows".equals(fieldName)) {
                    List<List> rows = reader.readArray(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    deserializedDataTableResponseObject.rows = rows;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataTableResponseObject;
        });
    }
}

