/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AzureResourceErrorInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Expression;
import java.io.IOException;
import java.util.List;

public final class ExpressionRoot
extends Expression {
    private String path;

    public String path() {
        return this.path;
    }

    public ExpressionRoot withPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public ExpressionRoot withText(String text) {
        super.withText(text);
        return this;
    }

    @Override
    public ExpressionRoot withValue(Object value) {
        super.withValue(value);
        return this;
    }

    @Override
    public ExpressionRoot withSubexpressions(List<Expression> subexpressions) {
        super.withSubexpressions(subexpressions);
        return this;
    }

    @Override
    public ExpressionRoot withError(AzureResourceErrorInfo error) {
        super.withError(error);
        return this;
    }

    @Override
    public void validate() {
        if (this.subexpressions() != null) {
            this.subexpressions().forEach(e -> e.validate());
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text());
        jsonWriter.writeUntypedField("value", this.value());
        jsonWriter.writeArrayField("subexpressions", this.subexpressions(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("error", this.error());
        jsonWriter.writeStringField("path", this.path);
        return jsonWriter.writeEndObject();
    }

    public static ExpressionRoot fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressionRoot deserializedExpressionRoot = new ExpressionRoot();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedExpressionRoot.withText(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedExpressionRoot.withValue(reader.readUntyped());
                    continue;
                }
                if ("subexpressions".equals(fieldName)) {
                    List<Expression> subexpressions = reader.readArray(reader1 -> Expression.fromJson(reader1));
                    deserializedExpressionRoot.withSubexpressions((List)subexpressions);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedExpressionRoot.withError(AzureResourceErrorInfo.fromJson(reader));
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedExpressionRoot.path = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressionRoot;
        });
    }
}

