/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class PerfMonSample
implements JsonSerializable<PerfMonSample> {
    private OffsetDateTime time;
    private String instanceName;
    private Double value;

    public OffsetDateTime time() {
        return this.time;
    }

    public PerfMonSample withTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public PerfMonSample withInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public Double value() {
        return this.value;
    }

    public PerfMonSample withValue(Double value) {
        this.value = value;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeStringField("instanceName", this.instanceName);
        jsonWriter.writeNumberField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static PerfMonSample fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PerfMonSample deserializedPerfMonSample = new PerfMonSample();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("time".equals(fieldName)) {
                    deserializedPerfMonSample.time = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("instanceName".equals(fieldName)) {
                    deserializedPerfMonSample.instanceName = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedPerfMonSample.value = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPerfMonSample;
        });
    }
}

