/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.NameValuePair;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.SolutionType;
import java.io.IOException;
import java.util.List;

public final class Solution
implements JsonSerializable<Solution> {
    private Double id;
    private String displayName;
    private Double order;
    private String description;
    private SolutionType type;
    private List<List<NameValuePair>> data;
    private List<List<NameValuePair>> metadata;

    public Double id() {
        return this.id;
    }

    public Solution withId(Double id) {
        this.id = id;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public Solution withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Double order() {
        return this.order;
    }

    public Solution withOrder(Double order) {
        this.order = order;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Solution withDescription(String description) {
        this.description = description;
        return this;
    }

    public SolutionType type() {
        return this.type;
    }

    public Solution withType(SolutionType type) {
        this.type = type;
        return this;
    }

    public List<List<NameValuePair>> data() {
        return this.data;
    }

    public Solution withData(List<List<NameValuePair>> data) {
        this.data = data;
        return this;
    }

    public List<List<NameValuePair>> metadata() {
        return this.metadata;
    }

    public Solution withMetadata(List<List<NameValuePair>> metadata) {
        this.metadata = metadata;
        return this;
    }

    public void validate() {
        if (this.data() != null) {
            this.data().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("id", this.id);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeNumberField("order", this.order);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeJson((JsonSerializable<?>)element1)));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeJson((JsonSerializable<?>)element1)));
        return jsonWriter.writeEndObject();
    }

    public static Solution fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Solution deserializedSolution = new Solution();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSolution.id = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSolution.displayName = reader.getString();
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedSolution.order = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSolution.description = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSolution.type = SolutionType.fromString(reader.getString());
                    continue;
                }
                if ("data".equals(fieldName)) {
                    List<List> data = reader.readArray(reader1 -> reader1.readArray(reader2 -> NameValuePair.fromJson(reader2)));
                    deserializedSolution.data = data;
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List<List> metadata = reader.readArray(reader1 -> reader1.readArray(reader2 -> NameValuePair.fromJson(reader2)));
                    deserializedSolution.metadata = metadata;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolution;
        });
    }
}

