/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPermissionScope;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPreAuthorizedApplication;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class MicrosoftGraphApiApplication
implements JsonSerializable<MicrosoftGraphApiApplication> {
    private Boolean acceptMappedClaims;
    private List<UUID> knownClientApplications;
    private List<MicrosoftGraphPermissionScope> oauth2PermissionScopes;
    private List<MicrosoftGraphPreAuthorizedApplication> preAuthorizedApplications;
    private Integer requestedAccessTokenVersion;
    private Map<String, Object> additionalProperties;

    public Boolean acceptMappedClaims() {
        return this.acceptMappedClaims;
    }

    public MicrosoftGraphApiApplication withAcceptMappedClaims(Boolean acceptMappedClaims) {
        this.acceptMappedClaims = acceptMappedClaims;
        return this;
    }

    public List<UUID> knownClientApplications() {
        return this.knownClientApplications;
    }

    public MicrosoftGraphApiApplication withKnownClientApplications(List<UUID> knownClientApplications) {
        this.knownClientApplications = knownClientApplications;
        return this;
    }

    public List<MicrosoftGraphPermissionScope> oauth2PermissionScopes() {
        return this.oauth2PermissionScopes;
    }

    public MicrosoftGraphApiApplication withOauth2PermissionScopes(List<MicrosoftGraphPermissionScope> oauth2PermissionScopes) {
        this.oauth2PermissionScopes = oauth2PermissionScopes;
        return this;
    }

    public List<MicrosoftGraphPreAuthorizedApplication> preAuthorizedApplications() {
        return this.preAuthorizedApplications;
    }

    public MicrosoftGraphApiApplication withPreAuthorizedApplications(List<MicrosoftGraphPreAuthorizedApplication> preAuthorizedApplications) {
        this.preAuthorizedApplications = preAuthorizedApplications;
        return this;
    }

    public Integer requestedAccessTokenVersion() {
        return this.requestedAccessTokenVersion;
    }

    public MicrosoftGraphApiApplication withRequestedAccessTokenVersion(Integer requestedAccessTokenVersion) {
        this.requestedAccessTokenVersion = requestedAccessTokenVersion;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphApiApplication withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.oauth2PermissionScopes() != null) {
            this.oauth2PermissionScopes().forEach(e -> e.validate());
        }
        if (this.preAuthorizedApplications() != null) {
            this.preAuthorizedApplications().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("acceptMappedClaims", this.acceptMappedClaims);
        jsonWriter.writeArrayField("knownClientApplications", this.knownClientApplications, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeArrayField("oauth2PermissionScopes", this.oauth2PermissionScopes, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("preAuthorizedApplications", this.preAuthorizedApplications, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("requestedAccessTokenVersion", this.requestedAccessTokenVersion);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphApiApplication fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphApiApplication deserializedMicrosoftGraphApiApplication = new MicrosoftGraphApiApplication();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("acceptMappedClaims".equals(fieldName)) {
                    deserializedMicrosoftGraphApiApplication.acceptMappedClaims = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("knownClientApplications".equals(fieldName)) {
                    List<UUID> knownClientApplications = reader.readArray(reader1 -> reader1.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString())));
                    deserializedMicrosoftGraphApiApplication.knownClientApplications = knownClientApplications;
                    continue;
                }
                if ("oauth2PermissionScopes".equals(fieldName)) {
                    List<MicrosoftGraphPermissionScope> oauth2PermissionScopes = reader.readArray(reader1 -> MicrosoftGraphPermissionScope.fromJson(reader1));
                    deserializedMicrosoftGraphApiApplication.oauth2PermissionScopes = oauth2PermissionScopes;
                    continue;
                }
                if ("preAuthorizedApplications".equals(fieldName)) {
                    List<MicrosoftGraphPreAuthorizedApplication> preAuthorizedApplications = reader.readArray(reader1 -> MicrosoftGraphPreAuthorizedApplication.fromJson(reader1));
                    deserializedMicrosoftGraphApiApplication.preAuthorizedApplications = preAuthorizedApplications;
                    continue;
                }
                if ("requestedAccessTokenVersion".equals(fieldName)) {
                    deserializedMicrosoftGraphApiApplication.requestedAccessTokenVersion = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphApiApplication.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphApiApplication;
        });
    }
}

