/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphEndpoint
extends MicrosoftGraphDirectoryObjectInner {
    private String capability;
    private String providerId;
    private String providerName;
    private String providerResourceId;
    private String uri;
    private Map<String, Object> additionalProperties;

    public String capability() {
        return this.capability;
    }

    public MicrosoftGraphEndpoint withCapability(String capability) {
        this.capability = capability;
        return this;
    }

    public String providerId() {
        return this.providerId;
    }

    public MicrosoftGraphEndpoint withProviderId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    public String providerName() {
        return this.providerName;
    }

    public MicrosoftGraphEndpoint withProviderName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    public String providerResourceId() {
        return this.providerResourceId;
    }

    public MicrosoftGraphEndpoint withProviderResourceId(String providerResourceId) {
        this.providerResourceId = providerResourceId;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public MicrosoftGraphEndpoint withUri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphEndpoint withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphEndpoint withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphEndpoint withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeStringField("capability", this.capability);
        jsonWriter.writeStringField("providerId", this.providerId);
        jsonWriter.writeStringField("providerName", this.providerName);
        jsonWriter.writeStringField("providerResourceId", this.providerResourceId);
        jsonWriter.writeStringField("uri", this.uri);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphEndpoint deserializedMicrosoftGraphEndpoint = new MicrosoftGraphEndpoint();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.withDeletedDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("capability".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.capability = reader.getString();
                    continue;
                }
                if ("providerId".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.providerId = reader.getString();
                    continue;
                }
                if ("providerName".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.providerName = reader.getString();
                    continue;
                }
                if ("providerResourceId".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.providerResourceId = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.uri = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphEndpoint.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphEndpoint;
        });
    }
}

