/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.Get2ItemsItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUserInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryUser;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.CountryIsoCode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Arrays;

class ActiveDirectoryUserImpl
extends CreatableUpdatableImpl<ActiveDirectoryUser, MicrosoftGraphUserInner, ActiveDirectoryUserImpl>
implements ActiveDirectoryUser,
ActiveDirectoryUser.Definition,
ActiveDirectoryUser.Update {
    private final AuthorizationManager manager;
    private String emailAlias;

    ActiveDirectoryUserImpl(MicrosoftGraphUserInner innerObject, AuthorizationManager manager) {
        super(innerObject.displayName(), innerObject);
        this.manager = manager;
    }

    @Override
    public String userPrincipalName() {
        return ((MicrosoftGraphUserInner)this.innerModel()).userPrincipalName();
    }

    @Override
    public String mail() {
        return ((MicrosoftGraphUserInner)this.innerModel()).mail();
    }

    @Override
    public String mailNickname() {
        return ((MicrosoftGraphUserInner)this.innerModel()).mailNickname();
    }

    @Override
    public CountryIsoCode usageLocation() {
        return CountryIsoCode.fromString(((MicrosoftGraphUserInner)this.innerModel()).usageLocation());
    }

    @Override
    public ActiveDirectoryUserImpl withUserPrincipalName(String userPrincipalName) {
        ((MicrosoftGraphUserInner)this.innerModel()).withUserPrincipalName(userPrincipalName);
        if (this.isInCreateMode()) {
            ((MicrosoftGraphUserInner)this.innerModel()).withMailNickname(userPrincipalName.replaceAll("@.+$", ""));
        }
        return this;
    }

    @Override
    public ActiveDirectoryUserImpl withEmailAlias(String emailAlias) {
        this.emailAlias = emailAlias;
        return this;
    }

    @Override
    public ActiveDirectoryUserImpl withPassword(String password) {
        if (((MicrosoftGraphUserInner)this.innerModel()).passwordProfile() == null) {
            ((MicrosoftGraphUserInner)this.innerModel()).withPasswordProfile(new MicrosoftGraphPasswordProfile());
        }
        ((MicrosoftGraphUserInner)this.innerModel()).passwordProfile().withPassword(password);
        return this;
    }

    @Override
    protected Mono<MicrosoftGraphUserInner> getInnerAsync() {
        return this.manager.serviceClient().getUsersUsers().getUserWithResponseAsync(this.id(), null, Arrays.asList(Get2ItemsItem.ID, Get2ItemsItem.DISPLAY_NAME, Get2ItemsItem.USER_PRINCIPAL_NAME, Get2ItemsItem.MAIL, Get2ItemsItem.MAIL_NICKNAME, Get2ItemsItem.USAGE_LOCATION, Get2ItemsItem.ACCOUNT_ENABLED), null).flatMap(FluxUtil::toMono);
    }

    @Override
    public boolean isInCreateMode() {
        return this.id() == null;
    }

    @Override
    public Mono<ActiveDirectoryUser> createResourceAsync() {
        if (((MicrosoftGraphUserInner)this.innerModel()).accountEnabled() == null) {
            ((MicrosoftGraphUserInner)this.innerModel()).withAccountEnabled(true);
        }
        Flux<Object> flux = Flux.empty();
        if (this.emailAlias != null) {
            flux = this.manager().serviceClient().getDomainsDomains().listDomainAsync().flatMap(domainInner -> {
                if (domainInner.isVerified().booleanValue() && domainInner.isDefault().booleanValue()) {
                    this.withUserPrincipalName(this.emailAlias + "@" + domainInner.id());
                }
                return Mono.empty();
            });
        }
        return flux.then(this.manager().serviceClient().getUsersUsers().createUserAsync((MicrosoftGraphUserInner)this.innerModel())).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<ActiveDirectoryUser> updateResourceAsync() {
        return this.manager().serviceClient().getUsersUsers().updateUserAsync(this.id(), (MicrosoftGraphUserInner)this.innerModel()).then(this.refreshAsync());
    }

    @Override
    public ActiveDirectoryUserImpl withPromptToChangePasswordOnLogin(boolean promptToChangePasswordOnLogin) {
        if (((MicrosoftGraphUserInner)this.innerModel()).passwordProfile() == null) {
            ((MicrosoftGraphUserInner)this.innerModel()).withPasswordProfile(new MicrosoftGraphPasswordProfile());
        }
        ((MicrosoftGraphUserInner)this.innerModel()).passwordProfile().withForceChangePasswordNextSignIn(promptToChangePasswordOnLogin);
        return this;
    }

    @Override
    public String toString() {
        return this.name() + " - " + this.userPrincipalName();
    }

    @Override
    public ActiveDirectoryUserImpl withAccountEnabled(boolean accountEnabled) {
        ((MicrosoftGraphUserInner)this.innerModel()).withAccountEnabled(accountEnabled);
        return this;
    }

    @Override
    public ActiveDirectoryUserImpl withUsageLocation(CountryIsoCode usageLocation) {
        ((MicrosoftGraphUserInner)this.innerModel()).withUsageLocation(usageLocation.toString());
        return this;
    }

    @Override
    public String id() {
        return ((MicrosoftGraphUserInner)this.innerModel()).id();
    }

    @Override
    public AuthorizationManager manager() {
        return this.manager;
    }
}

