/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.RoleDefinitionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.RoleDefinitionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.RoleDefinitionImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleDefinitions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class RoleDefinitionsImpl
extends ReadableWrappersImpl<RoleDefinition, RoleDefinitionImpl, RoleDefinitionInner>
implements RoleDefinitions {
    private final AuthorizationManager manager;

    public RoleDefinitionsImpl(AuthorizationManager manager) {
        this.manager = manager;
    }

    @Override
    protected RoleDefinitionImpl wrapModel(RoleDefinitionInner roleDefinitionInner) {
        if (roleDefinitionInner == null) {
            return null;
        }
        return new RoleDefinitionImpl(roleDefinitionInner, this.manager());
    }

    @Override
    public RoleDefinition getById(String objectId) {
        return this.getByIdAsync(objectId).block();
    }

    @Override
    public Mono<RoleDefinition> getByIdAsync(String id) {
        return this.inner().getByIdAsync(id).map(roleDefinitionInner -> new RoleDefinitionImpl((RoleDefinitionInner)roleDefinitionInner, this.manager()));
    }

    @Override
    public RoleDefinition getByScope(String scope, String name) {
        return this.getByScopeAsync(scope, name).block();
    }

    @Override
    public Mono<RoleDefinition> getByScopeAsync(String scope, String name) {
        return this.inner().getAsync(scope, name).map(roleDefinitionInner -> new RoleDefinitionImpl((RoleDefinitionInner)roleDefinitionInner, this.manager()));
    }

    @Override
    public RoleDefinition getByScopeAndRoleName(String scope, String roleName) {
        return this.getByScopeAndRoleNameAsync(scope, roleName).block();
    }

    @Override
    public PagedFlux<RoleDefinition> listByScopeAsync(String scope) {
        return PagedConverter.mapPage(this.inner().listAsync(scope, null), roleDefinitionInner -> new RoleDefinitionImpl((RoleDefinitionInner)roleDefinitionInner, this.manager()));
    }

    @Override
    public PagedIterable<RoleDefinition> listByScope(String scope) {
        return this.wrapList(this.inner().list(scope));
    }

    @Override
    public Mono<RoleDefinition> getByScopeAndRoleNameAsync(String scope, String roleName) {
        return this.inner().listAsync(scope, String.format("roleName eq '%s'", roleName)).singleOrEmpty().map(roleDefinitionInner -> new RoleDefinitionImpl((RoleDefinitionInner)roleDefinitionInner, this.manager()));
    }

    @Override
    public AuthorizationManager manager() {
        return this.manager;
    }

    public RoleDefinitionsClient inner() {
        return this.manager().roleServiceClient().getRoleDefinitions();
    }
}

