/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.RoleEligibilityScheduleInstancesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.RoleEligibilityScheduleInstanceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleInstanceListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class RoleEligibilityScheduleInstancesClientImpl
implements RoleEligibilityScheduleInstancesClient {
    private final RoleEligibilityScheduleInstancesService service;
    private final AuthorizationManagementClientImpl client;

    RoleEligibilityScheduleInstancesClientImpl(AuthorizationManagementClientImpl client) {
        this.service = RestProxy.create(RoleEligibilityScheduleInstancesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleEligibilityScheduleInstanceInner>> listForScopeSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RoleEligibilityScheduleInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleEligibilityScheduleInstanceListResult)res.getValue()).value(), ((RoleEligibilityScheduleInstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleEligibilityScheduleInstanceInner>> listForScopeSinglePageAsync(String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", context).map(res -> new PagedResponseBase<Object, RoleEligibilityScheduleInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleEligibilityScheduleInstanceListResult)res.getValue()).value(), ((RoleEligibilityScheduleInstanceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleEligibilityScheduleInstanceInner> listForScopeAsync(String scope, String filter) {
        return new PagedFlux<RoleEligibilityScheduleInstanceInner>(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleEligibilityScheduleInstanceInner> listForScopeAsync(String scope) {
        String filter = null;
        return new PagedFlux<RoleEligibilityScheduleInstanceInner>(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoleEligibilityScheduleInstanceInner> listForScopeAsync(String scope, String filter, Context context) {
        return new PagedFlux<RoleEligibilityScheduleInstanceInner>(() -> this.listForScopeSinglePageAsync(scope, filter, context), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleEligibilityScheduleInstanceInner> listForScope(String scope) {
        String filter = null;
        return new PagedIterable<RoleEligibilityScheduleInstanceInner>(this.listForScopeAsync(scope, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleEligibilityScheduleInstanceInner> listForScope(String scope, String filter, Context context) {
        return new PagedIterable<RoleEligibilityScheduleInstanceInner>(this.listForScopeAsync(scope, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleEligibilityScheduleInstanceInner>> getWithResponseAsync(String scope, String roleEligibilityScheduleInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleEligibilityScheduleInstanceName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scope, roleEligibilityScheduleInstanceName, "2020-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleEligibilityScheduleInstanceInner>> getWithResponseAsync(String scope, String roleEligibilityScheduleInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleEligibilityScheduleInstanceName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scope, roleEligibilityScheduleInstanceName, "2020-10-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleEligibilityScheduleInstanceInner> getAsync(String scope, String roleEligibilityScheduleInstanceName) {
        return this.getWithResponseAsync(scope, roleEligibilityScheduleInstanceName).flatMap(res -> Mono.justOrEmpty((RoleEligibilityScheduleInstanceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleEligibilityScheduleInstanceInner> getWithResponse(String scope, String roleEligibilityScheduleInstanceName, Context context) {
        return this.getWithResponseAsync(scope, roleEligibilityScheduleInstanceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleEligibilityScheduleInstanceInner get(String scope, String roleEligibilityScheduleInstanceName) {
        return this.getWithResponse(scope, roleEligibilityScheduleInstanceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleEligibilityScheduleInstanceInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RoleEligibilityScheduleInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleEligibilityScheduleInstanceListResult)res.getValue()).value(), ((RoleEligibilityScheduleInstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleEligibilityScheduleInstanceInner>> listForScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, RoleEligibilityScheduleInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleEligibilityScheduleInstanceListResult)res.getValue()).value(), ((RoleEligibilityScheduleInstanceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    public static interface RoleEligibilityScheduleInstancesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleInstances")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleEligibilityScheduleInstanceListResult>> listForScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleInstances/{roleEligibilityScheduleInstanceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleEligibilityScheduleInstanceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleEligibilityScheduleInstanceName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleEligibilityScheduleInstanceListResult>> listForScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

