/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ProfileLogScrubbing;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ProfileProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ProfileResourceState;
import java.io.IOException;
import java.util.Map;

public final class ProfileProperties
implements JsonSerializable<ProfileProperties> {
    private ProfileResourceState resourceState;
    private ProfileProvisioningState provisioningState;
    private Map<String, String> extendedProperties;
    private String frontDoorId;
    private Integer originResponseTimeoutSeconds;
    private ProfileLogScrubbing logScrubbing;

    public ProfileResourceState resourceState() {
        return this.resourceState;
    }

    public ProfileProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    public String frontDoorId() {
        return this.frontDoorId;
    }

    public Integer originResponseTimeoutSeconds() {
        return this.originResponseTimeoutSeconds;
    }

    public ProfileProperties withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        this.originResponseTimeoutSeconds = originResponseTimeoutSeconds;
        return this;
    }

    public ProfileLogScrubbing logScrubbing() {
        return this.logScrubbing;
    }

    public ProfileProperties withLogScrubbing(ProfileLogScrubbing logScrubbing) {
        this.logScrubbing = logScrubbing;
        return this;
    }

    public void validate() {
        if (this.logScrubbing() != null) {
            this.logScrubbing().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("originResponseTimeoutSeconds", this.originResponseTimeoutSeconds);
        jsonWriter.writeJsonField("logScrubbing", this.logScrubbing);
        return jsonWriter.writeEndObject();
    }

    public static ProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProfileProperties deserializedProfileProperties = new ProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceState".equals(fieldName)) {
                    deserializedProfileProperties.resourceState = ProfileResourceState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedProfileProperties.provisioningState = ProfileProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("extendedProperties".equals(fieldName)) {
                    Map<String, String> extendedProperties = reader.readMap(reader1 -> reader1.getString());
                    deserializedProfileProperties.extendedProperties = extendedProperties;
                    continue;
                }
                if ("frontDoorId".equals(fieldName)) {
                    deserializedProfileProperties.frontDoorId = reader.getString();
                    continue;
                }
                if ("originResponseTimeoutSeconds".equals(fieldName)) {
                    deserializedProfileProperties.originResponseTimeoutSeconds = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("logScrubbing".equals(fieldName)) {
                    deserializedProfileProperties.logScrubbing = ProfileLogScrubbing.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProfileProperties;
        });
    }
}

