/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CdnManagedHttpsParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CertificateSource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.MinimumTlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ProtocolType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.UserManagedHttpsParameters;
import java.io.IOException;

public class CustomDomainHttpsParameters
implements JsonSerializable<CustomDomainHttpsParameters> {
    private CertificateSource certificateSource = CertificateSource.fromString("CustomDomainHttpsParameters");
    private ProtocolType protocolType;
    private MinimumTlsVersion minimumTlsVersion;
    private static final ClientLogger LOGGER = new ClientLogger(CustomDomainHttpsParameters.class);

    public CertificateSource certificateSource() {
        return this.certificateSource;
    }

    public ProtocolType protocolType() {
        return this.protocolType;
    }

    public CustomDomainHttpsParameters withProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public CustomDomainHttpsParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public void validate() {
        if (this.protocolType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property protocolType in model CustomDomainHttpsParameters"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocolType", this.protocolType == null ? null : this.protocolType.toString());
        jsonWriter.writeStringField("certificateSource", this.certificateSource == null ? null : this.certificateSource.toString());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        return jsonWriter.writeEndObject();
    }

    public static CustomDomainHttpsParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                CustomDomainHttpsParameters customDomainHttpsParameters;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("certificateSource".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Cdn".equals(discriminatorValue)) {
                    customDomainHttpsParameters = CdnManagedHttpsParameters.fromJson(readerToUse.reset());
                    return customDomainHttpsParameters;
                }
                if ("AzureKeyVault".equals(discriminatorValue)) {
                    customDomainHttpsParameters = UserManagedHttpsParameters.fromJson(readerToUse.reset());
                    return customDomainHttpsParameters;
                }
                customDomainHttpsParameters = CustomDomainHttpsParameters.fromJsonKnownDiscriminator(readerToUse.reset());
                return customDomainHttpsParameters;
            }
        });
    }

    static CustomDomainHttpsParameters fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDomainHttpsParameters deserializedCustomDomainHttpsParameters = new CustomDomainHttpsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocolType".equals(fieldName)) {
                    deserializedCustomDomainHttpsParameters.protocolType = ProtocolType.fromString(reader.getString());
                    continue;
                }
                if ("certificateSource".equals(fieldName)) {
                    deserializedCustomDomainHttpsParameters.certificateSource = CertificateSource.fromString(reader.getString());
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedCustomDomainHttpsParameters.minimumTlsVersion = MinimumTlsVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomDomainHttpsParameters;
        });
    }
}

