/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CookiesMatchConditionParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.MatchVariable;
import java.io.IOException;

public final class DeliveryRuleCookiesCondition
extends DeliveryRuleCondition {
    private MatchVariable name = MatchVariable.COOKIES;
    private CookiesMatchConditionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleCookiesCondition.class);

    @Override
    public MatchVariable name() {
        return this.name;
    }

    public CookiesMatchConditionParameters parameters() {
        return this.parameters;
    }

    public DeliveryRuleCookiesCondition withParameters(CookiesMatchConditionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property parameters in model DeliveryRuleCookiesCondition"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleCookiesCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeliveryRuleCookiesCondition deserializedDeliveryRuleCookiesCondition = new DeliveryRuleCookiesCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleCookiesCondition.parameters = CookiesMatchConditionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleCookiesCondition.name = MatchVariable.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleCookiesCondition;
        });
    }
}

