/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.Operator;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.TransformType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.WafMatchVariable;
import java.io.IOException;
import java.util.List;

public final class MatchCondition
implements JsonSerializable<MatchCondition> {
    private WafMatchVariable matchVariable;
    private String selector;
    private Operator operator;
    private Boolean negateCondition;
    private List<String> matchValue;
    private List<TransformType> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(MatchCondition.class);

    public WafMatchVariable matchVariable() {
        return this.matchVariable;
    }

    public MatchCondition withMatchVariable(WafMatchVariable matchVariable) {
        this.matchVariable = matchVariable;
        return this;
    }

    public String selector() {
        return this.selector;
    }

    public MatchCondition withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    public Operator operator() {
        return this.operator;
    }

    public MatchCondition withOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public MatchCondition withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<String> matchValue() {
        return this.matchValue;
    }

    public MatchCondition withMatchValue(List<String> matchValue) {
        this.matchValue = matchValue;
        return this;
    }

    public List<TransformType> transforms() {
        return this.transforms;
    }

    public MatchCondition withTransforms(List<TransformType> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.matchVariable() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property matchVariable in model MatchCondition"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property operator in model MatchCondition"));
        }
        if (this.matchValue() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property matchValue in model MatchCondition"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("matchVariable", this.matchVariable == null ? null : this.matchVariable.toString());
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("matchValue", this.matchValue, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("selector", this.selector);
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static MatchCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MatchCondition deserializedMatchCondition = new MatchCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("matchVariable".equals(fieldName)) {
                    deserializedMatchCondition.matchVariable = WafMatchVariable.fromString(reader.getString());
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedMatchCondition.operator = Operator.fromString(reader.getString());
                    continue;
                }
                if ("matchValue".equals(fieldName)) {
                    List<String> matchValue = reader.readArray(reader1 -> reader1.getString());
                    deserializedMatchCondition.matchValue = matchValue;
                    continue;
                }
                if ("selector".equals(fieldName)) {
                    deserializedMatchCondition.selector = reader.getString();
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedMatchCondition.negateCondition = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List<TransformType> transforms = reader.readArray(reader1 -> TransformType.fromString(reader1.getString()));
                    deserializedMatchCondition.transforms = transforms;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMatchCondition;
        });
    }
}

