/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.AvailabilitySetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.ComputeManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.ComputeSkusImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.ComputeUsagesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.DiskEncryptionSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.DisksImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.GalleriesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.GalleryImageVersionsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.GalleryImagesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.SnapshotsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineCustomImagesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineExtensionImagesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineImagesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachinePublishersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineScaleSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachinesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AvailabilitySets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ComputeSkus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ComputeUsages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Disks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Galleries;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryImageVersions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryImages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Snapshots;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineCustomImages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineExtensionImages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineImages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineScaleSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachines;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import java.util.Objects;

public final class ComputeManager
extends Manager<ComputeManagementClient> {
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final AuthorizationManager authorizationManager;
    private AvailabilitySets availabilitySets;
    private VirtualMachines virtualMachines;
    private VirtualMachineImages virtualMachineImages;
    private VirtualMachineExtensionImages virtualMachineExtensionImages;
    private VirtualMachineScaleSets virtualMachineScaleSets;
    private ComputeUsages computeUsages;
    private VirtualMachineCustomImages virtualMachineCustomImages;
    private Disks disks;
    private Snapshots snapshots;
    private ComputeSkus computeSkus;
    private Galleries galleries;
    private GalleryImages galleryImages;
    private GalleryImageVersions galleryImageVersions;
    private DiskEncryptionSets diskEncryptionSets;

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public NetworkManager networkManager() {
        return this.networkManager;
    }

    public AuthorizationManager authorizationManager() {
        return this.authorizationManager;
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ComputeManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return ComputeManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static ComputeManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new ComputeManager(httpPipeline, profile);
    }

    private ComputeManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, new ComputeManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
        this.storageManager = StorageManager.authenticate(httpPipeline, profile);
        this.networkManager = NetworkManager.authenticate(httpPipeline, profile);
        this.authorizationManager = AuthorizationManager.authenticate(httpPipeline, profile);
    }

    public AvailabilitySets availabilitySets() {
        if (this.availabilitySets == null) {
            this.availabilitySets = new AvailabilitySetsImpl(this);
        }
        return this.availabilitySets;
    }

    public VirtualMachines virtualMachines() {
        if (this.virtualMachines == null) {
            this.virtualMachines = new VirtualMachinesImpl(this, this.storageManager, this.networkManager, this.authorizationManager);
        }
        return this.virtualMachines;
    }

    public VirtualMachineImages virtualMachineImages() {
        if (this.virtualMachineImages == null) {
            this.virtualMachineImages = new VirtualMachineImagesImpl(new VirtualMachinePublishersImpl(((ComputeManagementClient)this.serviceClient()).getVirtualMachineImages(), ((ComputeManagementClient)this.serviceClient()).getVirtualMachineExtensionImages()), ((ComputeManagementClient)this.serviceClient()).getVirtualMachineImages());
        }
        return this.virtualMachineImages;
    }

    public VirtualMachineExtensionImages virtualMachineExtensionImages() {
        if (this.virtualMachineExtensionImages == null) {
            this.virtualMachineExtensionImages = new VirtualMachineExtensionImagesImpl(new VirtualMachinePublishersImpl(((ComputeManagementClient)this.serviceClient()).getVirtualMachineImages(), ((ComputeManagementClient)this.serviceClient()).getVirtualMachineExtensionImages()));
        }
        return this.virtualMachineExtensionImages;
    }

    public VirtualMachineScaleSets virtualMachineScaleSets() {
        if (this.virtualMachineScaleSets == null) {
            this.virtualMachineScaleSets = new VirtualMachineScaleSetsImpl(this, this.storageManager, this.networkManager, this.authorizationManager);
        }
        return this.virtualMachineScaleSets;
    }

    public ComputeUsages usages() {
        if (this.computeUsages == null) {
            this.computeUsages = new ComputeUsagesImpl((ComputeManagementClient)this.serviceClient());
        }
        return this.computeUsages;
    }

    public VirtualMachineCustomImages virtualMachineCustomImages() {
        if (this.virtualMachineCustomImages == null) {
            this.virtualMachineCustomImages = new VirtualMachineCustomImagesImpl(this);
        }
        return this.virtualMachineCustomImages;
    }

    public Disks disks() {
        if (this.disks == null) {
            this.disks = new DisksImpl(this);
        }
        return this.disks;
    }

    public Snapshots snapshots() {
        if (this.snapshots == null) {
            this.snapshots = new SnapshotsImpl(this);
        }
        return this.snapshots;
    }

    public ComputeSkus computeSkus() {
        if (this.computeSkus == null) {
            this.computeSkus = new ComputeSkusImpl(this);
        }
        return this.computeSkus;
    }

    public Galleries galleries() {
        if (this.galleries == null) {
            this.galleries = new GalleriesImpl(this);
        }
        return this.galleries;
    }

    public GalleryImages galleryImages() {
        if (this.galleryImages == null) {
            this.galleryImages = new GalleryImagesImpl(this);
        }
        return this.galleryImages;
    }

    public GalleryImageVersions galleryImageVersions() {
        if (this.galleryImageVersions == null) {
            this.galleryImageVersions = new GalleryImageVersionsImpl(this);
        }
        return this.galleryImageVersions;
    }

    public DiskEncryptionSets diskEncryptionSets() {
        if (this.diskEncryptionSets == null) {
            this.diskEncryptionSets = new DiskEncryptionSetsImpl(this);
        }
        return this.diskEncryptionSets;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ComputeManager authenticate(TokenCredential credential, AzureProfile profile) {
            return ComputeManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ComputeManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

