/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ScheduledEventsPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineScaleSetMigrationInfo;
import java.io.IOException;
import java.util.List;

public final class AvailabilitySetProperties
implements JsonSerializable<AvailabilitySetProperties> {
    private Integer platformUpdateDomainCount;
    private Integer platformFaultDomainCount;
    private List<SubResource> virtualMachines;
    private SubResource proximityPlacementGroup;
    private List<InstanceViewStatus> statuses;
    private ScheduledEventsPolicy scheduledEventsPolicy;
    private VirtualMachineScaleSetMigrationInfo virtualMachineScaleSetMigrationInfo;

    public Integer platformUpdateDomainCount() {
        return this.platformUpdateDomainCount;
    }

    public AvailabilitySetProperties withPlatformUpdateDomainCount(Integer platformUpdateDomainCount) {
        this.platformUpdateDomainCount = platformUpdateDomainCount;
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    public AvailabilitySetProperties withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        this.platformFaultDomainCount = platformFaultDomainCount;
        return this;
    }

    public List<SubResource> virtualMachines() {
        return this.virtualMachines;
    }

    public AvailabilitySetProperties withVirtualMachines(List<SubResource> virtualMachines) {
        this.virtualMachines = virtualMachines;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public AvailabilitySetProperties withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public ScheduledEventsPolicy scheduledEventsPolicy() {
        return this.scheduledEventsPolicy;
    }

    public AvailabilitySetProperties withScheduledEventsPolicy(ScheduledEventsPolicy scheduledEventsPolicy) {
        this.scheduledEventsPolicy = scheduledEventsPolicy;
        return this;
    }

    public VirtualMachineScaleSetMigrationInfo virtualMachineScaleSetMigrationInfo() {
        return this.virtualMachineScaleSetMigrationInfo;
    }

    public void validate() {
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
        if (this.scheduledEventsPolicy() != null) {
            this.scheduledEventsPolicy().validate();
        }
        if (this.virtualMachineScaleSetMigrationInfo() != null) {
            this.virtualMachineScaleSetMigrationInfo().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("platformUpdateDomainCount", this.platformUpdateDomainCount);
        jsonWriter.writeNumberField("platformFaultDomainCount", this.platformFaultDomainCount);
        jsonWriter.writeArrayField("virtualMachines", this.virtualMachines, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("proximityPlacementGroup", this.proximityPlacementGroup);
        jsonWriter.writeJsonField("scheduledEventsPolicy", this.scheduledEventsPolicy);
        return jsonWriter.writeEndObject();
    }

    public static AvailabilitySetProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailabilitySetProperties deserializedAvailabilitySetProperties = new AvailabilitySetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("platformUpdateDomainCount".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.platformUpdateDomainCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("platformFaultDomainCount".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.platformFaultDomainCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("virtualMachines".equals(fieldName)) {
                    List<SubResource> virtualMachines = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedAvailabilitySetProperties.virtualMachines = virtualMachines;
                    continue;
                }
                if ("proximityPlacementGroup".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.proximityPlacementGroup = SubResource.fromJson(reader);
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedAvailabilitySetProperties.statuses = statuses;
                    continue;
                }
                if ("scheduledEventsPolicy".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.scheduledEventsPolicy = ScheduledEventsPolicy.fromJson(reader);
                    continue;
                }
                if ("virtualMachineScaleSetMigrationInfo".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.virtualMachineScaleSetMigrationInfo = VirtualMachineScaleSetMigrationInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailabilitySetProperties;
        });
    }
}

