/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryApplicationCustomAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class GalleryApplicationProperties
implements JsonSerializable<GalleryApplicationProperties> {
    private String description;
    private String eula;
    private String privacyStatementUri;
    private String releaseNoteUri;
    private OffsetDateTime endOfLifeDate;
    private OperatingSystemTypes supportedOSType;
    private List<GalleryApplicationCustomAction> customActions;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationProperties.class);

    public String description() {
        return this.description;
    }

    public GalleryApplicationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public GalleryApplicationProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public GalleryApplicationProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public String releaseNoteUri() {
        return this.releaseNoteUri;
    }

    public GalleryApplicationProperties withReleaseNoteUri(String releaseNoteUri) {
        this.releaseNoteUri = releaseNoteUri;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public GalleryApplicationProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public OperatingSystemTypes supportedOSType() {
        return this.supportedOSType;
    }

    public GalleryApplicationProperties withSupportedOSType(OperatingSystemTypes supportedOSType) {
        this.supportedOSType = supportedOSType;
        return this;
    }

    public List<GalleryApplicationCustomAction> customActions() {
        return this.customActions;
    }

    public GalleryApplicationProperties withCustomActions(List<GalleryApplicationCustomAction> customActions) {
        this.customActions = customActions;
        return this;
    }

    public void validate() {
        if (this.supportedOSType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property supportedOSType in model GalleryApplicationProperties"));
        }
        if (this.customActions() != null) {
            this.customActions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("supportedOSType", this.supportedOSType == null ? null : this.supportedOSType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("eula", this.eula);
        jsonWriter.writeStringField("privacyStatementUri", this.privacyStatementUri);
        jsonWriter.writeStringField("releaseNoteUri", this.releaseNoteUri);
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        jsonWriter.writeArrayField("customActions", this.customActions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static GalleryApplicationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryApplicationProperties deserializedGalleryApplicationProperties = new GalleryApplicationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("supportedOSType".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.supportedOSType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.description = reader.getString();
                    continue;
                }
                if ("eula".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.eula = reader.getString();
                    continue;
                }
                if ("privacyStatementUri".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.privacyStatementUri = reader.getString();
                    continue;
                }
                if ("releaseNoteUri".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.releaseNoteUri = reader.getString();
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.endOfLifeDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("customActions".equals(fieldName)) {
                    List<GalleryApplicationCustomAction> customActions = reader.readArray(reader1 -> GalleryApplicationCustomAction.fromJson(reader1));
                    deserializedGalleryApplicationProperties.customActions = customActions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryApplicationProperties;
        });
    }
}

