/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.AvailabilitySetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.ProximityPlacementGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineSizeInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.ProximityPlacementGroupImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineSizeImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AvailabilitySet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AvailabilitySetSkuTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ProximityPlacementGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ProximityPlacementGroupType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineSize;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AvailabilitySetImpl
extends GroupableResourceImpl<AvailabilitySet, AvailabilitySetInner, AvailabilitySetImpl, ComputeManager>
implements AvailabilitySet,
AvailabilitySet.Definition,
AvailabilitySet.Update {
    private Set<String> idOfVMsInSet;
    private String newProximityPlacementGroupName = null;
    private ProximityPlacementGroupType newProximityPlacementGroupType = null;

    AvailabilitySetImpl(String name, AvailabilitySetInner innerModel, ComputeManager computeManager) {
        super(name, innerModel, computeManager);
    }

    @Override
    public int updateDomainCount() {
        return ResourceManagerUtils.toPrimitiveInt(((AvailabilitySetInner)this.innerModel()).platformUpdateDomainCount());
    }

    @Override
    public int faultDomainCount() {
        return ResourceManagerUtils.toPrimitiveInt(((AvailabilitySetInner)this.innerModel()).platformFaultDomainCount());
    }

    @Override
    public AvailabilitySetSkuTypes sku() {
        if (((AvailabilitySetInner)this.innerModel()).sku() != null && ((AvailabilitySetInner)this.innerModel()).sku().name() != null) {
            return AvailabilitySetSkuTypes.fromString(((AvailabilitySetInner)this.innerModel()).sku().name());
        }
        return null;
    }

    @Override
    public Set<String> virtualMachineIds() {
        if (this.idOfVMsInSet == null && ((AvailabilitySetInner)this.innerModel()).virtualMachines() != null) {
            this.idOfVMsInSet = new HashSet<String>();
            for (SubResource resource : ((AvailabilitySetInner)this.innerModel()).virtualMachines()) {
                if (resource == null) continue;
                this.idOfVMsInSet.add(resource.id());
            }
        }
        return Collections.unmodifiableSet(this.idOfVMsInSet);
    }

    @Override
    public ProximityPlacementGroup proximityPlacementGroup() {
        if (((AvailabilitySetInner)this.innerModel()).proximityPlacementGroup() == null) {
            return null;
        }
        ResourceId id = ResourceId.fromString(((AvailabilitySetInner)this.innerModel()).proximityPlacementGroup().id());
        ProximityPlacementGroupInner plgInner = ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getProximityPlacementGroups().getByResourceGroup(id.resourceGroupName(), id.name());
        if (plgInner == null) {
            return null;
        }
        return new ProximityPlacementGroupImpl(plgInner);
    }

    @Override
    public List<InstanceViewStatus> statuses() {
        return Collections.unmodifiableList(((AvailabilitySetInner)this.innerModel()).statuses());
    }

    @Override
    public PagedIterable<VirtualMachineSize> listVirtualMachineSizes() {
        return PagedConverter.mapPage(((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getAvailabilitySets().listAvailableSizes(this.resourceGroupName(), this.name()), virtualMachineSizeInner -> new VirtualMachineSizeImpl((VirtualMachineSizeInner)virtualMachineSizeInner));
    }

    @Override
    public Mono<AvailabilitySet> refreshAsync() {
        return super.refreshAsync().map(availabilitySet -> {
            AvailabilitySetImpl impl = (AvailabilitySetImpl)availabilitySet;
            impl.idOfVMsInSet = null;
            return impl;
        });
    }

    @Override
    protected Mono<AvailabilitySetInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getAvailabilitySets().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public AvailabilitySetImpl withUpdateDomainCount(int updateDomainCount) {
        ((AvailabilitySetInner)this.innerModel()).withPlatformUpdateDomainCount(updateDomainCount);
        return this;
    }

    @Override
    public AvailabilitySetImpl withFaultDomainCount(int faultDomainCount) {
        ((AvailabilitySetInner)this.innerModel()).withPlatformFaultDomainCount(faultDomainCount);
        return this;
    }

    @Override
    public AvailabilitySetImpl withSku(AvailabilitySetSkuTypes skuType) {
        if (((AvailabilitySetInner)this.innerModel()).sku() == null) {
            ((AvailabilitySetInner)this.innerModel()).withSku(new Sku());
        }
        ((AvailabilitySetInner)this.innerModel()).sku().withName(skuType.toString());
        return this;
    }

    @Override
    public AvailabilitySetImpl withProximityPlacementGroup(String proximityPlacementGroupId) {
        ((AvailabilitySetInner)this.innerModel()).withProximityPlacementGroup(new SubResource().withId(proximityPlacementGroupId));
        this.newProximityPlacementGroupType = null;
        this.newProximityPlacementGroupName = null;
        return this;
    }

    @Override
    public AvailabilitySetImpl withNewProximityPlacementGroup(String proximityPlacementGroupName, ProximityPlacementGroupType type) {
        this.newProximityPlacementGroupName = proximityPlacementGroupName;
        this.newProximityPlacementGroupType = type;
        ((AvailabilitySetInner)this.innerModel()).withProximityPlacementGroup(null);
        return this;
    }

    @Override
    public AvailabilitySetImpl withoutProximityPlacementGroup() {
        ((AvailabilitySetInner)this.innerModel()).withProximityPlacementGroup(null);
        return this;
    }

    @Override
    public Mono<AvailabilitySet> createResourceAsync() {
        AvailabilitySetImpl self = this;
        if (((AvailabilitySetInner)this.innerModel()).platformFaultDomainCount() == null) {
            ((AvailabilitySetInner)this.innerModel()).withPlatformFaultDomainCount(2);
        }
        if (((AvailabilitySetInner)this.innerModel()).platformUpdateDomainCount() == null) {
            ((AvailabilitySetInner)this.innerModel()).withPlatformUpdateDomainCount(5);
        }
        return this.createNewProximityPlacementGroupAsync().flatMap(availabilitySet -> ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getAvailabilitySets().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AvailabilitySetInner)this.innerModel()).map(availabilitySetInner -> {
            self.setInner(availabilitySetInner);
            this.idOfVMsInSet = null;
            return self;
        }));
    }

    private Mono<AvailabilitySetImpl> createNewProximityPlacementGroupAsync() {
        if (this.isInCreateMode() && this.newProximityPlacementGroupName != null && !this.newProximityPlacementGroupName.isEmpty()) {
            ProximityPlacementGroupInner plgInner = new ProximityPlacementGroupInner();
            plgInner.withProximityPlacementGroupType(this.newProximityPlacementGroupType);
            plgInner.withLocation(((AvailabilitySetInner)this.innerModel()).location());
            return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getProximityPlacementGroups().createOrUpdateAsync(this.resourceGroupName(), this.newProximityPlacementGroupName, plgInner).map(createdPlgInner -> {
                ((AvailabilitySetInner)this.innerModel()).withProximityPlacementGroup(new SubResource().withId(createdPlgInner.id()));
                return this;
            });
        }
        return Mono.just(this);
    }
}

