/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.DiskInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AccessLevel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CreationData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CreationSource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Disk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskSkuTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskStorageAccountTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Encryption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EncryptionType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GrantAccessData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Snapshot;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SnapshotSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccount;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class DiskImpl
extends GroupableResourceImpl<Disk, DiskInner, DiskImpl, ComputeManager>
implements Disk,
Disk.Definition,
Disk.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    DiskImpl(String name, DiskInner innerModel, ComputeManager computeManager) {
        super(name, innerModel, computeManager);
    }

    @Override
    public DiskSkuTypes sku() {
        return DiskSkuTypes.fromDiskSku(((DiskInner)this.innerModel()).sku());
    }

    @Override
    public DiskCreateOption creationMethod() {
        return ((DiskInner)this.innerModel()).creationData().createOption();
    }

    @Override
    public boolean isAttachedToVirtualMachine() {
        return this.virtualMachineId() != null;
    }

    @Override
    public String virtualMachineId() {
        return ((DiskInner)this.innerModel()).managedBy();
    }

    @Override
    public int sizeInGB() {
        return ResourceManagerUtils.toPrimitiveInt(((DiskInner)this.innerModel()).diskSizeGB());
    }

    @Override
    public long sizeInByte() {
        return ((DiskInner)this.innerModel()).diskSizeBytes();
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((DiskInner)this.innerModel()).osType();
    }

    @Override
    public CreationSource source() {
        return new CreationSource(((DiskInner)this.innerModel()).creationData());
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((DiskInner)this.innerModel()).zones() != null) {
            for (String zone : ((DiskInner)this.innerModel()).zones()) {
                zones.add(AvailabilityZoneId.fromString(zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public EncryptionSettingsCollection encryptionSettings() {
        return ((DiskInner)this.innerModel()).encryptionSettingsCollection();
    }

    @Override
    public Encryption encryption() {
        return ((DiskInner)this.innerModel()).encryption();
    }

    @Override
    public String grantAccess(int accessDurationInSeconds) {
        return this.grantAccessAsync(accessDurationInSeconds).block();
    }

    @Override
    public Mono<String> grantAccessAsync(int accessDurationInSeconds) {
        GrantAccessData grantAccessDataInner = new GrantAccessData();
        grantAccessDataInner.withAccess(AccessLevel.READ).withDurationInSeconds(accessDurationInSeconds);
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().grantAccessAsync(this.resourceGroupName(), this.name(), grantAccessDataInner).map(accessUriInner -> accessUriInner.accessSas());
    }

    @Override
    public void revokeAccess() {
        this.revokeAccessAsync().block();
    }

    @Override
    public Mono<Void> revokeAccessAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().revokeAccessAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public boolean isHibernationSupported() {
        return ResourceManagerUtils.toPrimitiveBoolean(((DiskInner)this.innerModel()).supportsHibernation());
    }

    @Override
    public Integer logicalSectorSizeInBytes() {
        return ((DiskInner)this.innerModel()).creationData().logicalSectorSize();
    }

    @Override
    public HyperVGeneration hyperVGeneration() {
        return ((DiskInner)this.innerModel()).hyperVGeneration();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return ((DiskInner)this.innerModel()).publicNetworkAccess();
    }

    @Override
    public DiskImpl withLinuxFromVhd(String vhdUrl) {
        ((DiskInner)this.innerModel()).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public DiskImpl withLinuxFromDisk(String sourceDiskId) {
        ((DiskInner)this.innerModel()).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public DiskImpl withLinuxFromDisk(Disk sourceDisk) {
        this.withLinuxFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public DiskImpl withLinuxFromSnapshot(String sourceSnapshotId) {
        ((DiskInner)this.innerModel()).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public DiskImpl withLinuxFromSnapshot(Snapshot sourceSnapshot) {
        this.withLinuxFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(this.fromSnapshotSkuType(sourceSnapshot.skuType()));
        return this;
    }

    @Override
    public DiskImpl withWindowsFromVhd(String vhdUrl) {
        ((DiskInner)this.innerModel()).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public DiskImpl withWindowsFromDisk(String sourceDiskId) {
        ((DiskInner)this.innerModel()).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public DiskImpl withWindowsFromDisk(Disk sourceDisk) {
        this.withWindowsFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public DiskImpl withWindowsFromSnapshot(String sourceSnapshotId) {
        ((DiskInner)this.innerModel()).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public DiskImpl withWindowsFromSnapshot(Snapshot sourceSnapshot) {
        this.withWindowsFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(this.fromSnapshotSkuType(sourceSnapshot.skuType()));
        return this;
    }

    @Override
    public DiskImpl withData() {
        ((DiskInner)this.innerModel()).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.EMPTY);
        return this;
    }

    @Override
    public DiskImpl fromVhd(String vhdUrl) {
        ((DiskInner)this.innerModel()).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public DiskImpl withUploadSizeInMB(long uploadSizeInMB) {
        ((DiskInner)this.innerModel()).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.UPLOAD).withUploadSizeBytes(uploadSizeInMB * 1024L * 1024L + 512L);
        return this;
    }

    @Override
    public DiskImpl fromSnapshot(String snapshotId) {
        ((DiskInner)this.innerModel()).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(snapshotId);
        return this;
    }

    @Override
    public DiskImpl fromSnapshot(Snapshot snapshot) {
        return this.fromSnapshot(snapshot.id());
    }

    @Override
    public DiskImpl fromDisk(String managedDiskId) {
        ((DiskInner)this.innerModel()).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(managedDiskId);
        return this;
    }

    @Override
    public DiskImpl fromDisk(Disk managedDisk) {
        return this.fromDisk(managedDisk.id()).withOSType(managedDisk.osType()).withSku(managedDisk.sku());
    }

    @Override
    public DiskImpl withSizeInGB(int sizeInGB) {
        ((DiskInner)this.innerModel()).withDiskSizeGB(sizeInGB);
        return this;
    }

    @Override
    public DiskImpl withOSType(OperatingSystemTypes osType) {
        ((DiskInner)this.innerModel()).withOsType(osType);
        return this;
    }

    @Override
    public DiskImpl withSku(DiskSkuTypes sku) {
        ((DiskInner)this.innerModel()).withSku(new DiskSku().withName(sku.accountType()));
        return this;
    }

    @Override
    public DiskImpl withStorageAccountId(String storageAccountId) {
        ((DiskInner)this.innerModel()).creationData().withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public DiskImpl withStorageAccountName(String storageAccountName) {
        String id = ResourceUtils.constructResourceId(((ComputeManager)this.myManager).subscriptionId(), this.resourceGroupName(), "Microsoft.Storage", "storageAccounts", storageAccountName, "");
        return this.withStorageAccountId(id);
    }

    @Override
    public DiskImpl withStorageAccount(StorageAccount account) {
        return this.withStorageAccountId(account.id());
    }

    @Override
    public DiskImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((DiskInner)this.innerModel()).zones() == null) {
            ((DiskInner)this.innerModel()).withZones(new ArrayList<String>());
        }
        ((DiskInner)this.innerModel()).zones().add(zoneId.toString());
        return this;
    }

    @Override
    public DiskImpl withDiskEncryptionSet(String diskEncryptionSetId) {
        Encryption encryption = ((DiskInner)this.innerModel()).encryption();
        if (encryption == null) {
            encryption = new Encryption();
            ((DiskInner)this.innerModel()).withEncryption(encryption);
        }
        encryption.withDiskEncryptionSetId(diskEncryptionSetId);
        return this;
    }

    @Override
    public DiskImpl withDiskEncryptionSet(String diskEncryptionSetId, EncryptionType encryptionType) {
        Encryption encryption = ((DiskInner)this.innerModel()).encryption();
        if (encryption == null) {
            encryption = new Encryption();
            ((DiskInner)this.innerModel()).withEncryption(encryption);
        }
        encryption.withType(encryptionType);
        encryption.withDiskEncryptionSetId(diskEncryptionSetId);
        return this;
    }

    @Override
    public DiskImpl withHibernationSupport() {
        ((DiskInner)this.innerModel()).withSupportsHibernation(true);
        return this;
    }

    @Override
    public DiskImpl withoutHibernationSupport() {
        ((DiskInner)this.innerModel()).withSupportsHibernation(false);
        return this;
    }

    @Override
    public DiskImpl withLogicalSectorSizeInBytes(int logicalSectorSizeInBytes) {
        ((DiskInner)this.innerModel()).creationData().withLogicalSectorSize(logicalSectorSizeInBytes);
        return this;
    }

    @Override
    public Mono<Disk> createResourceAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().createOrUpdateAsync(this.resourceGroupName(), this.name(), (DiskInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<DiskInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Accepted<Disk> beginCreate() {
        return AcceptedImpl.newAccepted(this.logger, ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getHttpPipeline(), ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), (DiskInner)this.innerModel()).block(), inner -> new DiskImpl(inner.name(), (DiskInner)inner, (ComputeManager)this.manager()), DiskInner.class, () -> {
            Flux<Indexable> dependencyTasksAsync = this.taskGroup().invokeDependencyAsync(this.taskGroup().newInvocationContext());
            dependencyTasksAsync.blockLast();
        }, this::setInner, Context.NONE);
    }

    private DiskSkuTypes fromSnapshotSkuType(SnapshotSkuType skuType) {
        if (skuType == null) {
            return null;
        }
        return DiskSkuTypes.fromStorageAccountType(DiskStorageAccountTypes.fromString(skuType.toString()));
    }

    @Override
    public DiskImpl withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        ((DiskInner)this.innerModel()).withHyperVGeneration(hyperVGeneration);
        return this;
    }

    @Override
    public DiskImpl enablePublicNetworkAccess() {
        ((DiskInner)this.innerModel()).withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        return this;
    }

    @Override
    public DiskImpl disablePublicNetworkAccess() {
        ((DiskInner)this.innerModel()).withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        return this;
    }
}

