/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CachingTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DataDisk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualHardDisk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineUnmanagedDataDisk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

class UnmanagedDataDiskImpl
extends ChildResourceImpl<DataDisk, VirtualMachineImpl, VirtualMachine>
implements VirtualMachineUnmanagedDataDisk,
VirtualMachineUnmanagedDataDisk.DefinitionWithExistingVhd<VirtualMachine.DefinitionStages.WithUnmanagedCreate>,
VirtualMachineUnmanagedDataDisk.DefinitionWithNewVhd<VirtualMachine.DefinitionStages.WithUnmanagedCreate>,
VirtualMachineUnmanagedDataDisk.DefinitionWithImage<VirtualMachine.DefinitionStages.WithUnmanagedCreate>,
VirtualMachineUnmanagedDataDisk.UpdateDefinitionWithExistingVhd<VirtualMachine.Update>,
VirtualMachineUnmanagedDataDisk.UpdateDefinitionWithNewVhd<VirtualMachine.Update>,
VirtualMachineUnmanagedDataDisk.Update {
    protected UnmanagedDataDiskImpl(DataDisk inner, VirtualMachineImpl parent) {
        super(inner, parent);
    }

    protected static UnmanagedDataDiskImpl prepareDataDisk(String name, VirtualMachineImpl parent) {
        DataDisk dataDiskInner = new DataDisk();
        dataDiskInner.withLun(-1).withName(name).withVhd(null);
        return new UnmanagedDataDiskImpl(dataDiskInner, parent);
    }

    @Override
    public String name() {
        return ((DataDisk)this.innerModel()).name();
    }

    @Override
    public int size() {
        return ResourceManagerUtils.toPrimitiveInt(((DataDisk)this.innerModel()).diskSizeGB());
    }

    @Override
    public int lun() {
        return ResourceManagerUtils.toPrimitiveInt(((DataDisk)this.innerModel()).lun());
    }

    @Override
    public String vhdUri() {
        return ((DataDisk)this.innerModel()).vhd().uri();
    }

    @Override
    public CachingTypes cachingType() {
        return ((DataDisk)this.innerModel()).caching();
    }

    @Override
    public String sourceImageUri() {
        if (((DataDisk)this.innerModel()).image() != null) {
            return ((DataDisk)this.innerModel()).image().uri();
        }
        return null;
    }

    @Override
    public DiskCreateOptionTypes creationMethod() {
        return ((DataDisk)this.innerModel()).createOption();
    }

    public UnmanagedDataDiskImpl withNewVhd(int sizeInGB) {
        ((DataDisk)this.innerModel()).withCreateOption(DiskCreateOptionTypes.EMPTY).withDiskSizeGB(sizeInGB);
        return this;
    }

    public UnmanagedDataDiskImpl withExistingVhd(String storageAccountName, String containerName, String vhdName) {
        ((DataDisk)this.innerModel()).withCreateOption(DiskCreateOptionTypes.ATTACH).withVhd(new VirtualHardDisk().withUri(this.blobUrl(storageAccountName, containerName, vhdName)));
        return this;
    }

    public UnmanagedDataDiskImpl fromImage(int imageLun) {
        ((DataDisk)this.innerModel()).withCreateOption(DiskCreateOptionTypes.FROM_IMAGE).withLun(imageLun);
        return this;
    }

    @Override
    public UnmanagedDataDiskImpl withSizeInGB(Integer sizeInGB) {
        ((DataDisk)this.innerModel()).withDiskSizeGB(sizeInGB);
        return this;
    }

    @Override
    public UnmanagedDataDiskImpl withLun(Integer lun) {
        ((DataDisk)this.innerModel()).withLun(lun);
        return this;
    }

    @Override
    public UnmanagedDataDiskImpl withCaching(CachingTypes cachingType) {
        ((DataDisk)this.innerModel()).withCaching(cachingType);
        return this;
    }

    public UnmanagedDataDiskImpl storeAt(String storageAccountName, String containerName, String vhdName) {
        ((DataDisk)this.innerModel()).withVhd(new VirtualHardDisk());
        ((DataDisk)this.innerModel()).vhd().withUri(this.blobUrl(storageAccountName, containerName, vhdName));
        return this;
    }

    @Override
    public VirtualMachineImpl attach() {
        return ((VirtualMachineImpl)this.parent()).withUnmanagedDataDisk(this);
    }

    protected static void setDataDisksDefaults(List<VirtualMachineUnmanagedDataDisk> dataDisks, String namePrefix) {
        ArrayList<Integer> usedLuns = new ArrayList<Integer>();
        for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
            if (dataDisk.lun() == -1) continue;
            usedLuns.add(dataDisk.lun());
        }
        for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
            if (dataDisk.lun() == -1) {
                Integer i = 0;
                while (usedLuns.contains(i)) {
                    i = i + 1;
                }
                ((DataDisk)dataDisk.innerModel()).withLun(i);
                usedLuns.add(i);
            }
            if (dataDisk.name() == null) {
                ((DataDisk)dataDisk.innerModel()).withName(namePrefix + "-data-disk-" + dataDisk.lun());
            }
            if (((DataDisk)dataDisk.innerModel()).caching() != null) continue;
            ((DataDisk)dataDisk.innerModel()).withCaching(CachingTypes.READ_WRITE);
        }
    }

    protected static void ensureDisksVhdUri(List<VirtualMachineUnmanagedDataDisk> dataDisks, StorageAccount storageAccount, String namePrefix) {
        for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
            if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY && dataDisk.creationMethod() != DiskCreateOptionTypes.FROM_IMAGE || ((DataDisk)dataDisk.innerModel()).vhd() != null) continue;
            ((DataDisk)dataDisk.innerModel()).withVhd(new VirtualHardDisk());
            ((DataDisk)dataDisk.innerModel()).vhd().withUri(storageAccount.endPoints().primary().blob() + "vhds/" + namePrefix + "-data-disk-" + dataDisk.lun() + "-" + UUID.randomUUID().toString() + ".vhd");
        }
    }

    protected static void ensureDisksVhdUri(List<VirtualMachineUnmanagedDataDisk> dataDisks, String namePrefix) {
        String containerUrl = null;
        for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
            if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY || ((DataDisk)dataDisk.innerModel()).vhd() == null) continue;
            int idx = ((DataDisk)dataDisk.innerModel()).vhd().uri().lastIndexOf(47);
            containerUrl = ((DataDisk)dataDisk.innerModel()).vhd().uri().substring(0, idx);
            break;
        }
        if (containerUrl != null) {
            for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
                if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY || ((DataDisk)dataDisk.innerModel()).vhd() != null) continue;
                ((DataDisk)dataDisk.innerModel()).withVhd(new VirtualHardDisk());
                ((DataDisk)dataDisk.innerModel()).vhd().withUri(containerUrl + namePrefix + "-data-disk-" + dataDisk.lun() + "-" + UUID.randomUUID().toString() + ".vhd");
            }
        }
    }

    private String blobUrl(String storageAccountName, String containerName, String blobName) {
        AzureEnvironment azureEnvironment = ((VirtualMachineImpl)this.parent()).environment();
        return "https://" + storageAccountName + ".blob" + azureEnvironment.getStorageEndpointSuffix() + "/" + containerName + "/" + blobName;
    }
}

