/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.VirtualMachineImagesEdgeZonesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ApiErrorException;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.List;

public final class VirtualMachineImagesEdgeZonesClientImpl
implements VirtualMachineImagesEdgeZonesClient {
    private final VirtualMachineImagesEdgeZonesService service;
    private final ComputeManagementClientImpl client;

    VirtualMachineImagesEdgeZonesClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(VirtualMachineImagesEdgeZonesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualMachineImageInner>> getWithResponseAsync(String location, String edgeZone, String publisherName, String offer, String skus, String version) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (version == null) {
            return Mono.error(new IllegalArgumentException("Parameter version is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), location, edgeZone, publisherName, offer, skus, version, "2024-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualMachineImageInner>> getWithResponseAsync(String location, String edgeZone, String publisherName, String offer, String skus, String version, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (version == null) {
            return Mono.error(new IllegalArgumentException("Parameter version is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), location, edgeZone, publisherName, offer, skus, version, "2024-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineImageInner> getAsync(String location, String edgeZone, String publisherName, String offer, String skus, String version) {
        return this.getWithResponseAsync(location, edgeZone, publisherName, offer, skus, version).flatMap(res -> Mono.justOrEmpty((VirtualMachineImageInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualMachineImageInner> getWithResponse(String location, String edgeZone, String publisherName, String offer, String skus, String version, Context context) {
        return this.getWithResponseAsync(location, edgeZone, publisherName, offer, skus, version, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineImageInner get(String location, String edgeZone, String publisherName, String offer, String skus, String version) {
        return this.getWithResponse(location, edgeZone, publisherName, offer, skus, version, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listWithResponseAsync(String location, String edgeZone, String publisherName, String offer, String skus, String expand, Integer top, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), location, edgeZone, publisherName, offer, skus, expand, top, orderby, "2024-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listWithResponseAsync(String location, String edgeZone, String publisherName, String offer, String skus, String expand, Integer top, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), location, edgeZone, publisherName, offer, skus, expand, top, orderby, "2024-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listAsync(String location, String edgeZone, String publisherName, String offer, String skus) {
        String expand = null;
        Integer top = null;
        String orderby = null;
        return this.listWithResponseAsync(location, edgeZone, publisherName, offer, skus, expand, top, orderby).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listWithResponse(String location, String edgeZone, String publisherName, String offer, String skus, String expand, Integer top, String orderby, Context context) {
        return this.listWithResponseAsync(location, edgeZone, publisherName, offer, skus, expand, top, orderby, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> list(String location, String edgeZone, String publisherName, String offer, String skus) {
        String expand = null;
        Integer top = null;
        String orderby = null;
        return this.listWithResponse(location, edgeZone, publisherName, offer, skus, expand, top, orderby, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listOffersWithResponseAsync(String location, String edgeZone, String publisherName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOffers(this.client.getEndpoint(), location, edgeZone, publisherName, "2024-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listOffersWithResponseAsync(String location, String edgeZone, String publisherName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOffers(this.client.getEndpoint(), location, edgeZone, publisherName, "2024-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listOffersAsync(String location, String edgeZone, String publisherName) {
        return this.listOffersWithResponseAsync(location, edgeZone, publisherName).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listOffersWithResponse(String location, String edgeZone, String publisherName, Context context) {
        return this.listOffersWithResponseAsync(location, edgeZone, publisherName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> listOffers(String location, String edgeZone, String publisherName) {
        return this.listOffersWithResponse(location, edgeZone, publisherName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listPublishersWithResponseAsync(String location, String edgeZone) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPublishers(this.client.getEndpoint(), location, edgeZone, "2024-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listPublishersWithResponseAsync(String location, String edgeZone, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listPublishers(this.client.getEndpoint(), location, edgeZone, "2024-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listPublishersAsync(String location, String edgeZone) {
        return this.listPublishersWithResponseAsync(location, edgeZone).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listPublishersWithResponse(String location, String edgeZone, Context context) {
        return this.listPublishersWithResponseAsync(location, edgeZone, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> listPublishers(String location, String edgeZone) {
        return this.listPublishersWithResponse(location, edgeZone, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listSkusWithResponseAsync(String location, String edgeZone, String publisherName, String offer) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSkus(this.client.getEndpoint(), location, edgeZone, publisherName, offer, "2024-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listSkusWithResponseAsync(String location, String edgeZone, String publisherName, String offer, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSkus(this.client.getEndpoint(), location, edgeZone, publisherName, offer, "2024-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listSkusAsync(String location, String edgeZone, String publisherName, String offer) {
        return this.listSkusWithResponseAsync(location, edgeZone, publisherName, offer).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listSkusWithResponse(String location, String edgeZone, String publisherName, String offer, Context context) {
        return this.listSkusWithResponseAsync(location, edgeZone, publisherName, offer, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> listSkus(String location, String edgeZone, String publisherName, String offer) {
        return this.listSkusWithResponse(location, edgeZone, publisherName, offer, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    public static interface VirtualMachineImagesEdgeZonesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions/{version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<VirtualMachineImageInner>> get(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="edgeZone") String var3, @PathParam(value="publisherName") String var4, @PathParam(value="offer") String var5, @PathParam(value="skus") String var6, @PathParam(value="version") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<List<VirtualMachineImageResourceInner>>> list(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="edgeZone") String var3, @PathParam(value="publisherName") String var4, @PathParam(value="offer") String var5, @PathParam(value="skus") String var6, @QueryParam(value="$expand") String var7, @QueryParam(value="$top") Integer var8, @QueryParam(value="$orderby") String var9, @QueryParam(value="api-version") String var10, @PathParam(value="subscriptionId") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<List<VirtualMachineImageResourceInner>>> listOffers(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="edgeZone") String var3, @PathParam(value="publisherName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<List<VirtualMachineImageResourceInner>>> listPublishers(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="edgeZone") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<List<VirtualMachineImageResourceInner>>> listSkus(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="edgeZone") String var3, @PathParam(value="publisherName") String var4, @PathParam(value="offer") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

