/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CloudServiceExtensionProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CloudServiceNetworkProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CloudServiceOsProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CloudServiceRoleProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CloudServiceUpgradeMode;
import java.io.IOException;

public final class CloudServiceProperties
implements JsonSerializable<CloudServiceProperties> {
    private String packageUrl;
    private String configuration;
    private String configurationUrl;
    private Boolean startCloudService;
    private Boolean allowModelOverride;
    private CloudServiceUpgradeMode upgradeMode;
    private CloudServiceRoleProfile roleProfile;
    private CloudServiceOsProfile osProfile;
    private CloudServiceNetworkProfile networkProfile;
    private CloudServiceExtensionProfile extensionProfile;
    private String provisioningState;
    private String uniqueId;

    public String packageUrl() {
        return this.packageUrl;
    }

    public CloudServiceProperties withPackageUrl(String packageUrl) {
        this.packageUrl = packageUrl;
        return this;
    }

    public String configuration() {
        return this.configuration;
    }

    public CloudServiceProperties withConfiguration(String configuration) {
        this.configuration = configuration;
        return this;
    }

    public String configurationUrl() {
        return this.configurationUrl;
    }

    public CloudServiceProperties withConfigurationUrl(String configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public Boolean startCloudService() {
        return this.startCloudService;
    }

    public CloudServiceProperties withStartCloudService(Boolean startCloudService) {
        this.startCloudService = startCloudService;
        return this;
    }

    public Boolean allowModelOverride() {
        return this.allowModelOverride;
    }

    public CloudServiceProperties withAllowModelOverride(Boolean allowModelOverride) {
        this.allowModelOverride = allowModelOverride;
        return this;
    }

    public CloudServiceUpgradeMode upgradeMode() {
        return this.upgradeMode;
    }

    public CloudServiceProperties withUpgradeMode(CloudServiceUpgradeMode upgradeMode) {
        this.upgradeMode = upgradeMode;
        return this;
    }

    public CloudServiceRoleProfile roleProfile() {
        return this.roleProfile;
    }

    public CloudServiceProperties withRoleProfile(CloudServiceRoleProfile roleProfile) {
        this.roleProfile = roleProfile;
        return this;
    }

    public CloudServiceOsProfile osProfile() {
        return this.osProfile;
    }

    public CloudServiceProperties withOsProfile(CloudServiceOsProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public CloudServiceNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public CloudServiceProperties withNetworkProfile(CloudServiceNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public CloudServiceExtensionProfile extensionProfile() {
        return this.extensionProfile;
    }

    public CloudServiceProperties withExtensionProfile(CloudServiceExtensionProfile extensionProfile) {
        this.extensionProfile = extensionProfile;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public void validate() {
        if (this.roleProfile() != null) {
            this.roleProfile().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.extensionProfile() != null) {
            this.extensionProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("packageUrl", this.packageUrl);
        jsonWriter.writeStringField("configuration", this.configuration);
        jsonWriter.writeStringField("configurationUrl", this.configurationUrl);
        jsonWriter.writeBooleanField("startCloudService", this.startCloudService);
        jsonWriter.writeBooleanField("allowModelOverride", this.allowModelOverride);
        jsonWriter.writeStringField("upgradeMode", this.upgradeMode == null ? null : this.upgradeMode.toString());
        jsonWriter.writeJsonField("roleProfile", this.roleProfile);
        jsonWriter.writeJsonField("osProfile", this.osProfile);
        jsonWriter.writeJsonField("networkProfile", this.networkProfile);
        jsonWriter.writeJsonField("extensionProfile", this.extensionProfile);
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloudServiceProperties deserializedCloudServiceProperties = new CloudServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("packageUrl".equals(fieldName)) {
                    deserializedCloudServiceProperties.packageUrl = reader.getString();
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedCloudServiceProperties.configuration = reader.getString();
                    continue;
                }
                if ("configurationUrl".equals(fieldName)) {
                    deserializedCloudServiceProperties.configurationUrl = reader.getString();
                    continue;
                }
                if ("startCloudService".equals(fieldName)) {
                    deserializedCloudServiceProperties.startCloudService = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowModelOverride".equals(fieldName)) {
                    deserializedCloudServiceProperties.allowModelOverride = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("upgradeMode".equals(fieldName)) {
                    deserializedCloudServiceProperties.upgradeMode = CloudServiceUpgradeMode.fromString(reader.getString());
                    continue;
                }
                if ("roleProfile".equals(fieldName)) {
                    deserializedCloudServiceProperties.roleProfile = CloudServiceRoleProfile.fromJson(reader);
                    continue;
                }
                if ("osProfile".equals(fieldName)) {
                    deserializedCloudServiceProperties.osProfile = CloudServiceOsProfile.fromJson(reader);
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedCloudServiceProperties.networkProfile = CloudServiceNetworkProfile.fromJson(reader);
                    continue;
                }
                if ("extensionProfile".equals(fieldName)) {
                    deserializedCloudServiceProperties.extensionProfile = CloudServiceExtensionProfile.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCloudServiceProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("uniqueId".equals(fieldName)) {
                    deserializedCloudServiceProperties.uniqueId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceProperties;
        });
    }
}

