/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryApplicationCustomAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryArtifactPublishingProfileBase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryTargetExtendedLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ReplicationMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.StorageAccountType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.TargetRegion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.UserArtifactManage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.UserArtifactSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.UserArtifactSource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class GalleryApplicationVersionPublishingProfile
extends GalleryArtifactPublishingProfileBase {
    private UserArtifactSource source;
    private UserArtifactManage manageActions;
    private UserArtifactSettings settings;
    private Map<String, String> advancedSettings;
    private Boolean enableHealthCheck;
    private List<GalleryApplicationCustomAction> customActions;
    private OffsetDateTime publishedDate;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationVersionPublishingProfile.class);

    public UserArtifactSource source() {
        return this.source;
    }

    public GalleryApplicationVersionPublishingProfile withSource(UserArtifactSource source2) {
        this.source = source2;
        return this;
    }

    public UserArtifactManage manageActions() {
        return this.manageActions;
    }

    public GalleryApplicationVersionPublishingProfile withManageActions(UserArtifactManage manageActions) {
        this.manageActions = manageActions;
        return this;
    }

    public UserArtifactSettings settings() {
        return this.settings;
    }

    public GalleryApplicationVersionPublishingProfile withSettings(UserArtifactSettings settings) {
        this.settings = settings;
        return this;
    }

    public Map<String, String> advancedSettings() {
        return this.advancedSettings;
    }

    public GalleryApplicationVersionPublishingProfile withAdvancedSettings(Map<String, String> advancedSettings) {
        this.advancedSettings = advancedSettings;
        return this;
    }

    public Boolean enableHealthCheck() {
        return this.enableHealthCheck;
    }

    public GalleryApplicationVersionPublishingProfile withEnableHealthCheck(Boolean enableHealthCheck) {
        this.enableHealthCheck = enableHealthCheck;
        return this;
    }

    public List<GalleryApplicationCustomAction> customActions() {
        return this.customActions;
    }

    public GalleryApplicationVersionPublishingProfile withCustomActions(List<GalleryApplicationCustomAction> customActions) {
        this.customActions = customActions;
        return this;
    }

    @Override
    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withTargetRegions(List<TargetRegion> targetRegions) {
        super.withTargetRegions(targetRegions);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withReplicaCount(Integer replicaCount) {
        super.withReplicaCount(replicaCount);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withExcludeFromLatest(Boolean excludeFromLatest) {
        super.withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        super.withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withStorageAccountType(StorageAccountType storageAccountType) {
        super.withStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withReplicationMode(ReplicationMode replicationMode) {
        super.withReplicationMode(replicationMode);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withTargetExtendedLocations(List<GalleryTargetExtendedLocation> targetExtendedLocations) {
        super.withTargetExtendedLocations(targetExtendedLocations);
        return this;
    }

    @Override
    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property source in model GalleryApplicationVersionPublishingProfile"));
        }
        this.source().validate();
        if (this.manageActions() != null) {
            this.manageActions().validate();
        }
        if (this.settings() != null) {
            this.settings().validate();
        }
        if (this.customActions() != null) {
            this.customActions().forEach(e -> e.validate());
        }
        if (this.targetRegions() != null) {
            this.targetRegions().forEach(e -> e.validate());
        }
        if (this.targetExtendedLocations() != null) {
            this.targetExtendedLocations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetRegions", this.targetRegions(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("replicaCount", this.replicaCount());
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest());
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate()));
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType() == null ? null : this.storageAccountType().toString());
        jsonWriter.writeStringField("replicationMode", this.replicationMode() == null ? null : this.replicationMode().toString());
        jsonWriter.writeArrayField("targetExtendedLocations", this.targetExtendedLocations(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("source", this.source);
        jsonWriter.writeJsonField("manageActions", this.manageActions);
        jsonWriter.writeJsonField("settings", this.settings);
        jsonWriter.writeMapField("advancedSettings", this.advancedSettings, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("enableHealthCheck", this.enableHealthCheck);
        jsonWriter.writeArrayField("customActions", this.customActions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static GalleryApplicationVersionPublishingProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryApplicationVersionPublishingProfile deserializedGalleryApplicationVersionPublishingProfile = new GalleryApplicationVersionPublishingProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetRegions".equals(fieldName)) {
                    List<TargetRegion> targetRegions = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    deserializedGalleryApplicationVersionPublishingProfile.withTargetRegions((List)targetRegions);
                    continue;
                }
                if ("replicaCount".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.withReplicaCount(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.withExcludeFromLatest(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.publishedDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.withEndOfLifeDate(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.withStorageAccountType(StorageAccountType.fromString(reader.getString()));
                    continue;
                }
                if ("replicationMode".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.withReplicationMode(ReplicationMode.fromString(reader.getString()));
                    continue;
                }
                if ("targetExtendedLocations".equals(fieldName)) {
                    List<GalleryTargetExtendedLocation> targetExtendedLocations = reader.readArray(reader1 -> GalleryTargetExtendedLocation.fromJson(reader1));
                    deserializedGalleryApplicationVersionPublishingProfile.withTargetExtendedLocations((List)targetExtendedLocations);
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.source = UserArtifactSource.fromJson(reader);
                    continue;
                }
                if ("manageActions".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.manageActions = UserArtifactManage.fromJson(reader);
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.settings = UserArtifactSettings.fromJson(reader);
                    continue;
                }
                if ("advancedSettings".equals(fieldName)) {
                    Map<String, String> advancedSettings = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryApplicationVersionPublishingProfile.advancedSettings = advancedSettings;
                    continue;
                }
                if ("enableHealthCheck".equals(fieldName)) {
                    deserializedGalleryApplicationVersionPublishingProfile.enableHealthCheck = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customActions".equals(fieldName)) {
                    List<GalleryApplicationCustomAction> customActions = reader.readArray(reader1 -> GalleryApplicationCustomAction.fromJson(reader1));
                    deserializedGalleryApplicationVersionPublishingProfile.customActions = customActions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryApplicationVersionPublishingProfile;
        });
    }
}

