/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryTargetExtendedLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ReplicationMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.StorageAccountType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.TargetRegion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class GalleryArtifactPublishingProfileBase
implements JsonSerializable<GalleryArtifactPublishingProfileBase> {
    private List<TargetRegion> targetRegions;
    private Integer replicaCount;
    private Boolean excludeFromLatest;
    private OffsetDateTime publishedDate;
    private OffsetDateTime endOfLifeDate;
    private StorageAccountType storageAccountType;
    private ReplicationMode replicationMode;
    private List<GalleryTargetExtendedLocation> targetExtendedLocations;

    public List<TargetRegion> targetRegions() {
        return this.targetRegions;
    }

    public GalleryArtifactPublishingProfileBase withTargetRegions(List<TargetRegion> targetRegions) {
        this.targetRegions = targetRegions;
        return this;
    }

    public Integer replicaCount() {
        return this.replicaCount;
    }

    public GalleryArtifactPublishingProfileBase withReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
        return this;
    }

    public Boolean excludeFromLatest() {
        return this.excludeFromLatest;
    }

    public GalleryArtifactPublishingProfileBase withExcludeFromLatest(Boolean excludeFromLatest) {
        this.excludeFromLatest = excludeFromLatest;
        return this;
    }

    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    GalleryArtifactPublishingProfileBase withPublishedDate(OffsetDateTime publishedDate) {
        this.publishedDate = publishedDate;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public GalleryArtifactPublishingProfileBase withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    public GalleryArtifactPublishingProfileBase withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public ReplicationMode replicationMode() {
        return this.replicationMode;
    }

    public GalleryArtifactPublishingProfileBase withReplicationMode(ReplicationMode replicationMode) {
        this.replicationMode = replicationMode;
        return this;
    }

    public List<GalleryTargetExtendedLocation> targetExtendedLocations() {
        return this.targetExtendedLocations;
    }

    public GalleryArtifactPublishingProfileBase withTargetExtendedLocations(List<GalleryTargetExtendedLocation> targetExtendedLocations) {
        this.targetExtendedLocations = targetExtendedLocations;
        return this;
    }

    public void validate() {
        if (this.targetRegions() != null) {
            this.targetRegions().forEach(e -> e.validate());
        }
        if (this.targetExtendedLocations() != null) {
            this.targetExtendedLocations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetRegions", this.targetRegions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("replicaCount", this.replicaCount);
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest);
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeStringField("replicationMode", this.replicationMode == null ? null : this.replicationMode.toString());
        jsonWriter.writeArrayField("targetExtendedLocations", this.targetExtendedLocations, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static GalleryArtifactPublishingProfileBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryArtifactPublishingProfileBase deserializedGalleryArtifactPublishingProfileBase = new GalleryArtifactPublishingProfileBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetRegions".equals(fieldName)) {
                    List<TargetRegion> targetRegions = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    deserializedGalleryArtifactPublishingProfileBase.targetRegions = targetRegions;
                    continue;
                }
                if ("replicaCount".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.replicaCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.excludeFromLatest = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.publishedDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.endOfLifeDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.storageAccountType = StorageAccountType.fromString(reader.getString());
                    continue;
                }
                if ("replicationMode".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.replicationMode = ReplicationMode.fromString(reader.getString());
                    continue;
                }
                if ("targetExtendedLocations".equals(fieldName)) {
                    List<GalleryTargetExtendedLocation> targetExtendedLocations = reader.readArray(reader1 -> GalleryTargetExtendedLocation.fromJson(reader1));
                    deserializedGalleryArtifactPublishingProfileBase.targetExtendedLocations = targetExtendedLocations;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryArtifactPublishingProfileBase;
        });
    }
}

