/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CachingTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ImageDisk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.StorageAccountTypes;
import java.io.IOException;

public final class ImageDataDisk
extends ImageDisk {
    private int lun;

    public int lun() {
        return this.lun;
    }

    public ImageDataDisk withLun(int lun) {
        this.lun = lun;
        return this;
    }

    @Override
    public ImageDataDisk withSnapshot(SubResource snapshot) {
        super.withSnapshot(snapshot);
        return this;
    }

    @Override
    public ImageDataDisk withManagedDisk(SubResource managedDisk) {
        super.withManagedDisk(managedDisk);
        return this;
    }

    @Override
    public ImageDataDisk withBlobUri(String blobUri) {
        super.withBlobUri(blobUri);
        return this;
    }

    @Override
    public ImageDataDisk withCaching(CachingTypes caching) {
        super.withCaching(caching);
        return this;
    }

    @Override
    public ImageDataDisk withDiskSizeGB(Integer diskSizeGB) {
        super.withDiskSizeGB(diskSizeGB);
        return this;
    }

    @Override
    public ImageDataDisk withStorageAccountType(StorageAccountTypes storageAccountType) {
        super.withStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public ImageDataDisk withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        super.withDiskEncryptionSet(diskEncryptionSet);
        return this;
    }

    @Override
    public void validate() {
        if (this.diskEncryptionSet() != null) {
            this.diskEncryptionSet().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("snapshot", this.snapshot());
        jsonWriter.writeJsonField("managedDisk", this.managedDisk());
        jsonWriter.writeStringField("blobUri", this.blobUri());
        jsonWriter.writeStringField("caching", this.caching() == null ? null : this.caching().toString());
        jsonWriter.writeNumberField("diskSizeGB", this.diskSizeGB());
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType() == null ? null : this.storageAccountType().toString());
        jsonWriter.writeJsonField("diskEncryptionSet", this.diskEncryptionSet());
        jsonWriter.writeIntField("lun", this.lun);
        return jsonWriter.writeEndObject();
    }

    public static ImageDataDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageDataDisk deserializedImageDataDisk = new ImageDataDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("snapshot".equals(fieldName)) {
                    deserializedImageDataDisk.withSnapshot(SubResource.fromJson(reader));
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedImageDataDisk.withManagedDisk(SubResource.fromJson(reader));
                    continue;
                }
                if ("blobUri".equals(fieldName)) {
                    deserializedImageDataDisk.withBlobUri(reader.getString());
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedImageDataDisk.withCaching(CachingTypes.fromString(reader.getString()));
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedImageDataDisk.withDiskSizeGB(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedImageDataDisk.withStorageAccountType(StorageAccountTypes.fromString(reader.getString()));
                    continue;
                }
                if ("diskEncryptionSet".equals(fieldName)) {
                    deserializedImageDataDisk.withDiskEncryptionSet(DiskEncryptionSetParameters.fromJson(reader));
                    continue;
                }
                if ("lun".equals(fieldName)) {
                    deserializedImageDataDisk.lun = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageDataDisk;
        });
    }
}

