/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DataDisk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskControllerTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ImageReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OSDisk;
import java.io.IOException;
import java.util.List;

public final class StorageProfile
implements JsonSerializable<StorageProfile> {
    private ImageReference imageReference;
    private OSDisk osDisk;
    private List<DataDisk> dataDisks;
    private DiskControllerTypes diskControllerType;
    private Boolean alignRegionalDisksToVMZone;

    public ImageReference imageReference() {
        return this.imageReference;
    }

    public StorageProfile withImageReference(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public OSDisk osDisk() {
        return this.osDisk;
    }

    public StorageProfile withOsDisk(OSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public List<DataDisk> dataDisks() {
        return this.dataDisks;
    }

    public StorageProfile withDataDisks(List<DataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public DiskControllerTypes diskControllerType() {
        return this.diskControllerType;
    }

    public StorageProfile withDiskControllerType(DiskControllerTypes diskControllerType) {
        this.diskControllerType = diskControllerType;
        return this;
    }

    public Boolean alignRegionalDisksToVMZone() {
        return this.alignRegionalDisksToVMZone;
    }

    public StorageProfile withAlignRegionalDisksToVMZone(Boolean alignRegionalDisksToVMZone) {
        this.alignRegionalDisksToVMZone = alignRegionalDisksToVMZone;
        return this;
    }

    public void validate() {
        if (this.imageReference() != null) {
            this.imageReference().validate();
        }
        if (this.osDisk() != null) {
            this.osDisk().validate();
        }
        if (this.dataDisks() != null) {
            this.dataDisks().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("imageReference", this.imageReference);
        jsonWriter.writeJsonField("osDisk", this.osDisk);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("diskControllerType", this.diskControllerType == null ? null : this.diskControllerType.toString());
        jsonWriter.writeBooleanField("alignRegionalDisksToVMZone", this.alignRegionalDisksToVMZone);
        return jsonWriter.writeEndObject();
    }

    public static StorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageProfile deserializedStorageProfile = new StorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("imageReference".equals(fieldName)) {
                    deserializedStorageProfile.imageReference = ImageReference.fromJson(reader);
                    continue;
                }
                if ("osDisk".equals(fieldName)) {
                    deserializedStorageProfile.osDisk = OSDisk.fromJson(reader);
                    continue;
                }
                if ("dataDisks".equals(fieldName)) {
                    List<DataDisk> dataDisks = reader.readArray(reader1 -> DataDisk.fromJson(reader1));
                    deserializedStorageProfile.dataDisks = dataDisks;
                    continue;
                }
                if ("diskControllerType".equals(fieldName)) {
                    deserializedStorageProfile.diskControllerType = DiskControllerTypes.fromString(reader.getString());
                    continue;
                }
                if ("alignRegionalDisksToVMZone".equals(fieldName)) {
                    deserializedStorageProfile.alignRegionalDisksToVMZone = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageProfile;
        });
    }
}

