/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CachingTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskDeleteOptionTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineScaleSetManagedDiskParameters;
import java.io.IOException;

public final class VirtualMachineScaleSetDataDisk
implements JsonSerializable<VirtualMachineScaleSetDataDisk> {
    private String name;
    private int lun;
    private CachingTypes caching;
    private Boolean writeAcceleratorEnabled;
    private DiskCreateOptionTypes createOption;
    private Integer diskSizeGB;
    private VirtualMachineScaleSetManagedDiskParameters managedDisk;
    private Long diskIopsReadWrite;
    private Long diskMBpsReadWrite;
    private DiskDeleteOptionTypes deleteOption;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetDataDisk.class);

    public String name() {
        return this.name;
    }

    public VirtualMachineScaleSetDataDisk withName(String name) {
        this.name = name;
        return this;
    }

    public int lun() {
        return this.lun;
    }

    public VirtualMachineScaleSetDataDisk withLun(int lun) {
        this.lun = lun;
        return this;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public VirtualMachineScaleSetDataDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public VirtualMachineScaleSetDataDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public DiskCreateOptionTypes createOption() {
        return this.createOption;
    }

    public VirtualMachineScaleSetDataDisk withCreateOption(DiskCreateOptionTypes createOption) {
        this.createOption = createOption;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public VirtualMachineScaleSetDataDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public VirtualMachineScaleSetManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public VirtualMachineScaleSetDataDisk withManagedDisk(VirtualMachineScaleSetManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public Long diskIopsReadWrite() {
        return this.diskIopsReadWrite;
    }

    public VirtualMachineScaleSetDataDisk withDiskIopsReadWrite(Long diskIopsReadWrite) {
        this.diskIopsReadWrite = diskIopsReadWrite;
        return this;
    }

    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    public VirtualMachineScaleSetDataDisk withDiskMBpsReadWrite(Long diskMBpsReadWrite) {
        this.diskMBpsReadWrite = diskMBpsReadWrite;
        return this;
    }

    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineScaleSetDataDisk withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.createOption() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property createOption in model VirtualMachineScaleSetDataDisk"));
        }
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("lun", this.lun);
        jsonWriter.writeStringField("createOption", this.createOption == null ? null : this.createOption.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        jsonWriter.writeNumberField("diskSizeGB", this.diskSizeGB);
        jsonWriter.writeJsonField("managedDisk", this.managedDisk);
        jsonWriter.writeNumberField("diskIOPSReadWrite", this.diskIopsReadWrite);
        jsonWriter.writeNumberField("diskMBpsReadWrite", this.diskMBpsReadWrite);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetDataDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetDataDisk deserializedVirtualMachineScaleSetDataDisk = new VirtualMachineScaleSetDataDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lun".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.lun = reader.getInt();
                    continue;
                }
                if ("createOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.createOption = DiskCreateOptionTypes.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.name = reader.getString();
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.writeAcceleratorEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.diskSizeGB = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.managedDisk = VirtualMachineScaleSetManagedDiskParameters.fromJson(reader);
                    continue;
                }
                if ("diskIOPSReadWrite".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.diskIopsReadWrite = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskMBpsReadWrite".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.diskMBpsReadWrite = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.deleteOption = DiskDeleteOptionTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetDataDisk;
        });
    }
}

