/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.ContainerInstanceManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.implementation.ContainerGroupsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.implementation.ContainerInstanceManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import java.util.Objects;

public final class ContainerInstanceManager
extends Manager<ContainerInstanceManagementClient> {
    private ContainerGroupsImpl containerGroups;
    private final StorageManager storageManager;
    private final AuthorizationManager authorizationManager;
    private final NetworkManager networkManager;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ContainerInstanceManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return ContainerInstanceManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static ContainerInstanceManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new ContainerInstanceManager(httpPipeline, profile);
    }

    private ContainerInstanceManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, new ContainerInstanceManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
        this.storageManager = StorageManager.authenticate(httpPipeline, profile);
        this.authorizationManager = AuthorizationManager.authenticate(httpPipeline, profile);
        this.networkManager = NetworkManager.authenticate(httpPipeline, profile);
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public AuthorizationManager authorizationManager() {
        return this.authorizationManager;
    }

    public NetworkManager networkManager() {
        return this.networkManager;
    }

    public ContainerGroups containerGroups() {
        if (this.containerGroups == null) {
            this.containerGroups = new ContainerGroupsImpl(this);
        }
        return this.containerGroups;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ContainerInstanceManager authenticate(TokenCredential credential, AzureProfile profile) {
            return ContainerInstanceManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ContainerInstanceManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

