/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ConfidentialComputeProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.Container;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupDiagnostics;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupPriority;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupPropertiesInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupRestartPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupSubnetId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.DeploymentExtensionSpec;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.DnsConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.EncryptionProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ImageRegistryCredential;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.InitContainerDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.IpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.Volume;
import java.io.IOException;
import java.util.List;

public final class ContainerGroupProperties
implements JsonSerializable<ContainerGroupProperties> {
    private String provisioningState;
    private List<Container> containers;
    private List<ImageRegistryCredential> imageRegistryCredentials;
    private ContainerGroupRestartPolicy restartPolicy;
    private IpAddress ipAddress;
    private OperatingSystemTypes osType;
    private List<Volume> volumes;
    private ContainerGroupPropertiesInstanceView instanceView;
    private ContainerGroupDiagnostics diagnostics;
    private List<ContainerGroupSubnetId> subnetIds;
    private DnsConfiguration dnsConfig;
    private ContainerGroupSku sku;
    private EncryptionProperties encryptionProperties;
    private List<InitContainerDefinition> initContainers;
    private List<DeploymentExtensionSpec> extensions;
    private ConfidentialComputeProperties confidentialComputeProperties;
    private ContainerGroupPriority priority;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerGroupProperties.class);

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<Container> containers() {
        return this.containers;
    }

    public ContainerGroupProperties withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public List<ImageRegistryCredential> imageRegistryCredentials() {
        return this.imageRegistryCredentials;
    }

    public ContainerGroupProperties withImageRegistryCredentials(List<ImageRegistryCredential> imageRegistryCredentials) {
        this.imageRegistryCredentials = imageRegistryCredentials;
        return this;
    }

    public ContainerGroupRestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    public ContainerGroupProperties withRestartPolicy(ContainerGroupRestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    public IpAddress ipAddress() {
        return this.ipAddress;
    }

    public ContainerGroupProperties withIpAddress(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public ContainerGroupProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public ContainerGroupProperties withVolumes(List<Volume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public ContainerGroupPropertiesInstanceView instanceView() {
        return this.instanceView;
    }

    public ContainerGroupDiagnostics diagnostics() {
        return this.diagnostics;
    }

    public ContainerGroupProperties withDiagnostics(ContainerGroupDiagnostics diagnostics) {
        this.diagnostics = diagnostics;
        return this;
    }

    public List<ContainerGroupSubnetId> subnetIds() {
        return this.subnetIds;
    }

    public ContainerGroupProperties withSubnetIds(List<ContainerGroupSubnetId> subnetIds) {
        this.subnetIds = subnetIds;
        return this;
    }

    public DnsConfiguration dnsConfig() {
        return this.dnsConfig;
    }

    public ContainerGroupProperties withDnsConfig(DnsConfiguration dnsConfig) {
        this.dnsConfig = dnsConfig;
        return this;
    }

    public ContainerGroupSku sku() {
        return this.sku;
    }

    public ContainerGroupProperties withSku(ContainerGroupSku sku) {
        this.sku = sku;
        return this;
    }

    public EncryptionProperties encryptionProperties() {
        return this.encryptionProperties;
    }

    public ContainerGroupProperties withEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        return this;
    }

    public List<InitContainerDefinition> initContainers() {
        return this.initContainers;
    }

    public ContainerGroupProperties withInitContainers(List<InitContainerDefinition> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public List<DeploymentExtensionSpec> extensions() {
        return this.extensions;
    }

    public ContainerGroupProperties withExtensions(List<DeploymentExtensionSpec> extensions) {
        this.extensions = extensions;
        return this;
    }

    public ConfidentialComputeProperties confidentialComputeProperties() {
        return this.confidentialComputeProperties;
    }

    public ContainerGroupProperties withConfidentialComputeProperties(ConfidentialComputeProperties confidentialComputeProperties) {
        this.confidentialComputeProperties = confidentialComputeProperties;
        return this;
    }

    public ContainerGroupPriority priority() {
        return this.priority;
    }

    public ContainerGroupProperties withPriority(ContainerGroupPriority priority) {
        this.priority = priority;
        return this;
    }

    public void validate() {
        if (this.containers() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property containers in model ContainerGroupProperties"));
        }
        this.containers().forEach(e -> e.validate());
        if (this.imageRegistryCredentials() != null) {
            this.imageRegistryCredentials().forEach(e -> e.validate());
        }
        if (this.ipAddress() != null) {
            this.ipAddress().validate();
        }
        if (this.osType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property osType in model ContainerGroupProperties"));
        }
        if (this.volumes() != null) {
            this.volumes().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.diagnostics() != null) {
            this.diagnostics().validate();
        }
        if (this.subnetIds() != null) {
            this.subnetIds().forEach(e -> e.validate());
        }
        if (this.dnsConfig() != null) {
            this.dnsConfig().validate();
        }
        if (this.encryptionProperties() != null) {
            this.encryptionProperties().validate();
        }
        if (this.initContainers() != null) {
            this.initContainers().forEach(e -> e.validate());
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.confidentialComputeProperties() != null) {
            this.confidentialComputeProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeArrayField("imageRegistryCredentials", this.imageRegistryCredentials, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("restartPolicy", this.restartPolicy == null ? null : this.restartPolicy.toString());
        jsonWriter.writeJsonField("ipAddress", this.ipAddress);
        jsonWriter.writeArrayField("volumes", this.volumes, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("diagnostics", this.diagnostics);
        jsonWriter.writeArrayField("subnetIds", this.subnetIds, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("dnsConfig", this.dnsConfig);
        jsonWriter.writeStringField("sku", this.sku == null ? null : this.sku.toString());
        jsonWriter.writeJsonField("encryptionProperties", this.encryptionProperties);
        jsonWriter.writeArrayField("initContainers", this.initContainers, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("confidentialComputeProperties", this.confidentialComputeProperties);
        jsonWriter.writeStringField("priority", this.priority == null ? null : this.priority.toString());
        return jsonWriter.writeEndObject();
    }

    public static ContainerGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerGroupProperties deserializedContainerGroupProperties = new ContainerGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containers".equals(fieldName)) {
                    List<Container> containers = reader.readArray(reader1 -> Container.fromJson(reader1));
                    deserializedContainerGroupProperties.containers = containers;
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedContainerGroupProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedContainerGroupProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("imageRegistryCredentials".equals(fieldName)) {
                    List<ImageRegistryCredential> imageRegistryCredentials = reader.readArray(reader1 -> ImageRegistryCredential.fromJson(reader1));
                    deserializedContainerGroupProperties.imageRegistryCredentials = imageRegistryCredentials;
                    continue;
                }
                if ("restartPolicy".equals(fieldName)) {
                    deserializedContainerGroupProperties.restartPolicy = ContainerGroupRestartPolicy.fromString(reader.getString());
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedContainerGroupProperties.ipAddress = IpAddress.fromJson(reader);
                    continue;
                }
                if ("volumes".equals(fieldName)) {
                    List<Volume> volumes = reader.readArray(reader1 -> Volume.fromJson(reader1));
                    deserializedContainerGroupProperties.volumes = volumes;
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedContainerGroupProperties.instanceView = ContainerGroupPropertiesInstanceView.fromJson(reader);
                    continue;
                }
                if ("diagnostics".equals(fieldName)) {
                    deserializedContainerGroupProperties.diagnostics = ContainerGroupDiagnostics.fromJson(reader);
                    continue;
                }
                if ("subnetIds".equals(fieldName)) {
                    List<ContainerGroupSubnetId> subnetIds = reader.readArray(reader1 -> ContainerGroupSubnetId.fromJson(reader1));
                    deserializedContainerGroupProperties.subnetIds = subnetIds;
                    continue;
                }
                if ("dnsConfig".equals(fieldName)) {
                    deserializedContainerGroupProperties.dnsConfig = DnsConfiguration.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedContainerGroupProperties.sku = ContainerGroupSku.fromString(reader.getString());
                    continue;
                }
                if ("encryptionProperties".equals(fieldName)) {
                    deserializedContainerGroupProperties.encryptionProperties = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("initContainers".equals(fieldName)) {
                    List<InitContainerDefinition> initContainers = reader.readArray(reader1 -> InitContainerDefinition.fromJson(reader1));
                    deserializedContainerGroupProperties.initContainers = initContainers;
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List<DeploymentExtensionSpec> extensions = reader.readArray(reader1 -> DeploymentExtensionSpec.fromJson(reader1));
                    deserializedContainerGroupProperties.extensions = extensions;
                    continue;
                }
                if ("confidentialComputeProperties".equals(fieldName)) {
                    deserializedContainerGroupProperties.confidentialComputeProperties = ConfidentialComputeProperties.fromJson(reader);
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedContainerGroupProperties.priority = ContainerGroupPriority.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerGroupProperties;
        });
    }
}

