/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.ContainerRegistryManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistriesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistryTaskRunsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistryTasksImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Registries;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryTaskRuns;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryTasks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import java.util.Objects;

public final class ContainerRegistryManager
extends Manager<ContainerRegistryManagementClient> {
    private RegistriesImpl registries;
    private RegistryTasksImpl tasks;
    private RegistryTaskRunsImpl registryTaskRuns;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ContainerRegistryManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return ContainerRegistryManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static ContainerRegistryManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new ContainerRegistryManager(httpPipeline, profile);
    }

    private ContainerRegistryManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, new ContainerRegistryManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public Registries containerRegistries() {
        if (this.registries == null) {
            this.registries = new RegistriesImpl(this);
        }
        return this.registries;
    }

    public RegistryTasks containerRegistryTasks() {
        if (this.tasks == null) {
            this.tasks = new RegistryTasksImpl(this);
        }
        return this.tasks;
    }

    public RegistryTaskRuns registryTaskRuns() {
        if (this.registryTaskRuns == null) {
            this.registryTaskRuns = new RegistryTaskRunsImpl(this);
        }
        return this.registryTaskRuns;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ContainerRegistryManager authenticate(TokenCredential credential, AzureProfile profile) {
            return ContainerRegistryManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ContainerRegistryManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

