/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.WebhooksClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.WebhookInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.RegistryImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.implementation.WebhookImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Registries;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Webhook;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class RegistriesWebhooksClientImpl
implements Registries.WebhooksClient {
    private final ContainerRegistryManager containerRegistryManager;
    private final RegistryImpl containerRegistry;

    RegistriesWebhooksClientImpl(ContainerRegistryManager containerRegistryManager, RegistryImpl containerRegistry) {
        this.containerRegistryManager = containerRegistryManager;
        this.containerRegistry = containerRegistry;
    }

    @Override
    public Webhook get(String resourceGroupName, String registryName, String webhookName) {
        return this.getAsync(resourceGroupName, registryName, webhookName).block();
    }

    @Override
    public Mono<Webhook> getAsync(String resourceGroupName, String registryName, String webhookName) {
        WebhooksClient webhooksInner = ((ContainerRegistryManagementClient)this.containerRegistryManager.serviceClient()).getWebhooks();
        return webhooksInner.getAsync(resourceGroupName, registryName, webhookName).map(webhookInner -> {
            if (this.containerRegistry != null) {
                return new WebhookImpl(webhookName, this.containerRegistry, (WebhookInner)webhookInner, this.containerRegistryManager);
            }
            return new WebhookImpl(resourceGroupName, registryName, webhookName, (WebhookInner)webhookInner, this.containerRegistryManager);
        }).flatMap(WebhookImpl::setCallbackConfigAsync);
    }

    @Override
    public void delete(String resourceGroupName, String registryName, String webhookName) {
        ((ContainerRegistryManagementClient)this.containerRegistryManager.serviceClient()).getWebhooks().delete(resourceGroupName, registryName, webhookName);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String webhookName) {
        return ((ContainerRegistryManagementClient)this.containerRegistryManager.serviceClient()).getWebhooks().deleteAsync(resourceGroupName, registryName, webhookName);
    }

    @Override
    public PagedIterable<Webhook> list(String resourceGroupName, String registryName) {
        return new PagedIterable<Webhook>(this.listAsync(resourceGroupName, registryName));
    }

    @Override
    public PagedFlux<Webhook> listAsync(String resourceGroupName, String registryName) {
        WebhooksClient webhooksInner = ((ContainerRegistryManagementClient)this.containerRegistryManager.serviceClient()).getWebhooks();
        return PagedConverter.flatMapPage(PagedConverter.mapPage(webhooksInner.listAsync(resourceGroupName, registryName), inner -> {
            if (this.containerRegistry != null) {
                return new WebhookImpl(inner.name(), this.containerRegistry, (WebhookInner)inner, this.containerRegistryManager);
            }
            return new WebhookImpl(resourceGroupName, registryName, inner.name(), (WebhookInner)inner, this.containerRegistryManager);
        }), WebhookImpl::setCallbackConfigAsync);
    }
}

