/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.NetworkProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterAgentPoolProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterAuthProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterMasterPoolProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OpenShiftRouterProfile;
import java.io.IOException;
import java.util.List;

public final class OpenShiftManagedClusterProperties
implements JsonSerializable<OpenShiftManagedClusterProperties> {
    private String provisioningState;
    private String openShiftVersion;
    private String clusterVersion;
    private String publicHostname;
    private String fqdn;
    private NetworkProfile networkProfile;
    private List<OpenShiftRouterProfile> routerProfiles;
    private OpenShiftManagedClusterMasterPoolProfile masterPoolProfile;
    private List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles;
    private OpenShiftManagedClusterAuthProfile authProfile;
    private static final ClientLogger LOGGER = new ClientLogger(OpenShiftManagedClusterProperties.class);

    public String provisioningState() {
        return this.provisioningState;
    }

    public String openShiftVersion() {
        return this.openShiftVersion;
    }

    public OpenShiftManagedClusterProperties withOpenShiftVersion(String openShiftVersion) {
        this.openShiftVersion = openShiftVersion;
        return this;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public String publicHostname() {
        return this.publicHostname;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public OpenShiftManagedClusterProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public List<OpenShiftRouterProfile> routerProfiles() {
        return this.routerProfiles;
    }

    public OpenShiftManagedClusterProperties withRouterProfiles(List<OpenShiftRouterProfile> routerProfiles) {
        this.routerProfiles = routerProfiles;
        return this;
    }

    public OpenShiftManagedClusterMasterPoolProfile masterPoolProfile() {
        return this.masterPoolProfile;
    }

    public OpenShiftManagedClusterProperties withMasterPoolProfile(OpenShiftManagedClusterMasterPoolProfile masterPoolProfile) {
        this.masterPoolProfile = masterPoolProfile;
        return this;
    }

    public List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    public OpenShiftManagedClusterProperties withAgentPoolProfiles(List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    public OpenShiftManagedClusterAuthProfile authProfile() {
        return this.authProfile;
    }

    public OpenShiftManagedClusterProperties withAuthProfile(OpenShiftManagedClusterAuthProfile authProfile) {
        this.authProfile = authProfile;
        return this;
    }

    public void validate() {
        if (this.openShiftVersion() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property openShiftVersion in model OpenShiftManagedClusterProperties"));
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.routerProfiles() != null) {
            this.routerProfiles().forEach(e -> e.validate());
        }
        if (this.masterPoolProfile() != null) {
            this.masterPoolProfile().validate();
        }
        if (this.agentPoolProfiles() != null) {
            this.agentPoolProfiles().forEach(e -> e.validate());
        }
        if (this.authProfile() != null) {
            this.authProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("openShiftVersion", this.openShiftVersion);
        jsonWriter.writeJsonField("networkProfile", this.networkProfile);
        jsonWriter.writeArrayField("routerProfiles", this.routerProfiles, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("masterPoolProfile", this.masterPoolProfile);
        jsonWriter.writeArrayField("agentPoolProfiles", this.agentPoolProfiles, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("authProfile", this.authProfile);
        return jsonWriter.writeEndObject();
    }

    public static OpenShiftManagedClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenShiftManagedClusterProperties deserializedOpenShiftManagedClusterProperties = new OpenShiftManagedClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("openShiftVersion".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.openShiftVersion = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("clusterVersion".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.clusterVersion = reader.getString();
                    continue;
                }
                if ("publicHostname".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.publicHostname = reader.getString();
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.fqdn = reader.getString();
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.networkProfile = NetworkProfile.fromJson(reader);
                    continue;
                }
                if ("routerProfiles".equals(fieldName)) {
                    List<OpenShiftRouterProfile> routerProfiles = reader.readArray(reader1 -> OpenShiftRouterProfile.fromJson(reader1));
                    deserializedOpenShiftManagedClusterProperties.routerProfiles = routerProfiles;
                    continue;
                }
                if ("masterPoolProfile".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.masterPoolProfile = OpenShiftManagedClusterMasterPoolProfile.fromJson(reader);
                    continue;
                }
                if ("agentPoolProfiles".equals(fieldName)) {
                    List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles = reader.readArray(reader1 -> OpenShiftManagedClusterAgentPoolProfile.fromJson(reader1));
                    deserializedOpenShiftManagedClusterProperties.agentPoolProfiles = agentPoolProfiles;
                    continue;
                }
                if ("authProfile".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.authProfile = OpenShiftManagedClusterAuthProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenShiftManagedClusterProperties;
        });
    }
}

