/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.IstioCertificateAuthority;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.IstioComponents;
import java.io.IOException;
import java.util.List;

public final class IstioServiceMesh
implements JsonSerializable<IstioServiceMesh> {
    private IstioComponents components;
    private IstioCertificateAuthority certificateAuthority;
    private List<String> revisions;

    public IstioComponents components() {
        return this.components;
    }

    public IstioServiceMesh withComponents(IstioComponents components) {
        this.components = components;
        return this;
    }

    public IstioCertificateAuthority certificateAuthority() {
        return this.certificateAuthority;
    }

    public IstioServiceMesh withCertificateAuthority(IstioCertificateAuthority certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return this;
    }

    public List<String> revisions() {
        return this.revisions;
    }

    public IstioServiceMesh withRevisions(List<String> revisions) {
        this.revisions = revisions;
        return this;
    }

    public void validate() {
        if (this.components() != null) {
            this.components().validate();
        }
        if (this.certificateAuthority() != null) {
            this.certificateAuthority().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("components", this.components);
        jsonWriter.writeJsonField("certificateAuthority", this.certificateAuthority);
        jsonWriter.writeArrayField("revisions", this.revisions, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static IstioServiceMesh fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IstioServiceMesh deserializedIstioServiceMesh = new IstioServiceMesh();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("components".equals(fieldName)) {
                    deserializedIstioServiceMesh.components = IstioComponents.fromJson(reader);
                    continue;
                }
                if ("certificateAuthority".equals(fieldName)) {
                    deserializedIstioServiceMesh.certificateAuthority = IstioCertificateAuthority.fromJson(reader);
                    continue;
                }
                if ("revisions".equals(fieldName)) {
                    List<String> revisions = reader.readArray(reader1 -> reader1.getString());
                    deserializedIstioServiceMesh.revisions = revisions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIstioServiceMesh;
        });
    }
}

