/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.ManagedClusterPoolUpgradeProfileUpgradesItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OSType;
import java.io.IOException;
import java.util.List;

public final class ManagedClusterPoolUpgradeProfile
implements JsonSerializable<ManagedClusterPoolUpgradeProfile> {
    private String kubernetesVersion;
    private String name;
    private OSType osType;
    private List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterPoolUpgradeProfile.class);

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public ManagedClusterPoolUpgradeProfile withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ManagedClusterPoolUpgradeProfile withName(String name) {
        this.name = name;
        return this;
    }

    public OSType osType() {
        return this.osType;
    }

    public ManagedClusterPoolUpgradeProfile withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    public List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades() {
        return this.upgrades;
    }

    public ManagedClusterPoolUpgradeProfile withUpgrades(List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    public void validate() {
        if (this.kubernetesVersion() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property kubernetesVersion in model ManagedClusterPoolUpgradeProfile"));
        }
        if (this.osType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property osType in model ManagedClusterPoolUpgradeProfile"));
        }
        if (this.upgrades() != null) {
            this.upgrades().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kubernetesVersion", this.kubernetesVersion);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("upgrades", this.upgrades, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterPoolUpgradeProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterPoolUpgradeProfile deserializedManagedClusterPoolUpgradeProfile = new ManagedClusterPoolUpgradeProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedManagedClusterPoolUpgradeProfile.kubernetesVersion = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedManagedClusterPoolUpgradeProfile.osType = OSType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedClusterPoolUpgradeProfile.name = reader.getString();
                    continue;
                }
                if ("upgrades".equals(fieldName)) {
                    List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades = reader.readArray(reader1 -> ManagedClusterPoolUpgradeProfileUpgradesItem.fromJson(reader1));
                    deserializedManagedClusterPoolUpgradeProfile.upgrades = upgrades;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterPoolUpgradeProfile;
        });
    }
}

