/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.WeekDay;
import java.io.IOException;

public final class WeeklySchedule
implements JsonSerializable<WeeklySchedule> {
    private int intervalWeeks;
    private WeekDay dayOfWeek;
    private static final ClientLogger LOGGER = new ClientLogger(WeeklySchedule.class);

    public int intervalWeeks() {
        return this.intervalWeeks;
    }

    public WeeklySchedule withIntervalWeeks(int intervalWeeks) {
        this.intervalWeeks = intervalWeeks;
        return this;
    }

    public WeekDay dayOfWeek() {
        return this.dayOfWeek;
    }

    public WeeklySchedule withDayOfWeek(WeekDay dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    public void validate() {
        if (this.dayOfWeek() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property dayOfWeek in model WeeklySchedule"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("intervalWeeks", this.intervalWeeks);
        jsonWriter.writeStringField("dayOfWeek", this.dayOfWeek == null ? null : this.dayOfWeek.toString());
        return jsonWriter.writeEndObject();
    }

    public static WeeklySchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WeeklySchedule deserializedWeeklySchedule = new WeeklySchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("intervalWeeks".equals(fieldName)) {
                    deserializedWeeklySchedule.intervalWeeks = reader.getInt();
                    continue;
                }
                if ("dayOfWeek".equals(fieldName)) {
                    deserializedWeeklySchedule.dayOfWeek = WeekDay.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWeeklySchedule;
        });
    }
}

