/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.CollectionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.MetricDefinitionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.MetricInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.UsageInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.MetricDefinitionsListResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.MetricListResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.UsagesResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class CollectionsClientImpl
implements CollectionsClient {
    private final CollectionsService service;
    private final CosmosDBManagementClientImpl client;

    CollectionsClientImpl(CosmosDBManagementClientImpl client) {
        this.service = RestProxy.create(CollectionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, MetricInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", context).map(res -> new PagedResponseBase<Object, MetricInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricInner> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return new PagedFlux<MetricInner>(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MetricInner> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedFlux<MetricInner>(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return new PagedIterable<MetricInner>(this.listMetricsAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedIterable<MetricInner>(this.listMetricsAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listUsagesSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listUsages(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, UsageInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listUsagesSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listUsages(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", context).map(res -> new PagedResponseBase<Object, UsageInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<UsageInner> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return new PagedFlux<UsageInner>(() -> this.listUsagesSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<UsageInner> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        String filter = null;
        return new PagedFlux<UsageInner>(() -> this.listUsagesSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<UsageInner> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedFlux<UsageInner>(() -> this.listUsagesSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UsageInner> listUsages(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        String filter = null;
        return new PagedIterable<UsageInner>(this.listUsagesAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UsageInner> listUsages(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedIterable<UsageInner>(this.listUsagesAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MetricDefinitionInner>> listMetricDefinitionsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetricDefinitions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, MetricDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionsListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MetricDefinitionInner>> listMetricDefinitionsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listMetricDefinitions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, MetricDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionsListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricDefinitionInner> listMetricDefinitionsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return new PagedFlux<MetricDefinitionInner>(() -> this.listMetricDefinitionsSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MetricDefinitionInner> listMetricDefinitionsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, Context context) {
        return new PagedFlux<MetricDefinitionInner>(() -> this.listMetricDefinitionsSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return new PagedIterable<MetricDefinitionInner>(this.listMetricDefinitionsAsync(resourceGroupName, accountName, databaseRid, collectionRid));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String accountName, String databaseRid, String collectionRid, Context context) {
        return new PagedIterable<MetricDefinitionInner>(this.listMetricDefinitionsAsync(resourceGroupName, accountName, databaseRid, collectionRid, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    public static interface CollectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricListResult>> listMetrics(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseRid") String var5, @PathParam(value="collectionRid") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$filter") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/usages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UsagesResult>> listUsages(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseRid") String var5, @PathParam(value="collectionRid") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$filter") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/metricDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricDefinitionsListResult>> listMetricDefinitions(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseRid") String var5, @PathParam(value="collectionRid") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

