/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.RestorableGremlinResourcesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.RestorableGremlinResourcesGetResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.RestorableGremlinResourcesListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class RestorableGremlinResourcesClientImpl
implements RestorableGremlinResourcesClient {
    private final RestorableGremlinResourcesService service;
    private final CosmosDBManagementClientImpl client;

    RestorableGremlinResourcesClientImpl(CosmosDBManagementClientImpl client) {
        this.service = RestProxy.create(RestorableGremlinResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableGremlinResourcesGetResultInner>> listSinglePageAsync(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restoreLocation, restoreTimestampInUtc, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RestorableGremlinResourcesGetResultInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableGremlinResourcesListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableGremlinResourcesGetResultInner>> listSinglePageAsync(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restoreLocation, restoreTimestampInUtc, "application/json", context).map(res -> new PagedResponseBase<Object, RestorableGremlinResourcesGetResultInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableGremlinResourcesListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableGremlinResourcesGetResultInner> listAsync(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc) {
        return new PagedFlux<RestorableGremlinResourcesGetResultInner>(() -> this.listSinglePageAsync(location, instanceId, restoreLocation, restoreTimestampInUtc));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableGremlinResourcesGetResultInner> listAsync(String location, String instanceId) {
        String restoreLocation = null;
        String restoreTimestampInUtc = null;
        return new PagedFlux<RestorableGremlinResourcesGetResultInner>(() -> this.listSinglePageAsync(location, instanceId, restoreLocation, restoreTimestampInUtc));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RestorableGremlinResourcesGetResultInner> listAsync(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc, Context context) {
        return new PagedFlux<RestorableGremlinResourcesGetResultInner>(() -> this.listSinglePageAsync(location, instanceId, restoreLocation, restoreTimestampInUtc, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableGremlinResourcesGetResultInner> list(String location, String instanceId) {
        String restoreLocation = null;
        String restoreTimestampInUtc = null;
        return new PagedIterable<RestorableGremlinResourcesGetResultInner>(this.listAsync(location, instanceId, restoreLocation, restoreTimestampInUtc));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableGremlinResourcesGetResultInner> list(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc, Context context) {
        return new PagedIterable<RestorableGremlinResourcesGetResultInner>(this.listAsync(location, instanceId, restoreLocation, restoreTimestampInUtc, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    public static interface RestorableGremlinResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{instanceId}/restorableGremlinResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RestorableGremlinResourcesListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @PathParam(value="instanceId") String var5, @QueryParam(value="restoreLocation") String var6, @QueryParam(value="restoreTimestampInUtc") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

