/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DefaultConsistencyLevel;
import java.io.IOException;

public final class ConsistencyPolicy
implements JsonSerializable<ConsistencyPolicy> {
    private DefaultConsistencyLevel defaultConsistencyLevel;
    private Long maxStalenessPrefix;
    private Integer maxIntervalInSeconds;
    private static final ClientLogger LOGGER = new ClientLogger(ConsistencyPolicy.class);

    public DefaultConsistencyLevel defaultConsistencyLevel() {
        return this.defaultConsistencyLevel;
    }

    public ConsistencyPolicy withDefaultConsistencyLevel(DefaultConsistencyLevel defaultConsistencyLevel) {
        this.defaultConsistencyLevel = defaultConsistencyLevel;
        return this;
    }

    public Long maxStalenessPrefix() {
        return this.maxStalenessPrefix;
    }

    public ConsistencyPolicy withMaxStalenessPrefix(Long maxStalenessPrefix) {
        this.maxStalenessPrefix = maxStalenessPrefix;
        return this;
    }

    public Integer maxIntervalInSeconds() {
        return this.maxIntervalInSeconds;
    }

    public ConsistencyPolicy withMaxIntervalInSeconds(Integer maxIntervalInSeconds) {
        this.maxIntervalInSeconds = maxIntervalInSeconds;
        return this;
    }

    public void validate() {
        if (this.defaultConsistencyLevel() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property defaultConsistencyLevel in model ConsistencyPolicy"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultConsistencyLevel", this.defaultConsistencyLevel == null ? null : this.defaultConsistencyLevel.toString());
        jsonWriter.writeNumberField("maxStalenessPrefix", this.maxStalenessPrefix);
        jsonWriter.writeNumberField("maxIntervalInSeconds", this.maxIntervalInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static ConsistencyPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConsistencyPolicy deserializedConsistencyPolicy = new ConsistencyPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultConsistencyLevel".equals(fieldName)) {
                    deserializedConsistencyPolicy.defaultConsistencyLevel = DefaultConsistencyLevel.fromString(reader.getString());
                    continue;
                }
                if ("maxStalenessPrefix".equals(fieldName)) {
                    deserializedConsistencyPolicy.maxStalenessPrefix = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maxIntervalInSeconds".equals(fieldName)) {
                    deserializedConsistencyPolicy.maxIntervalInSeconds = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConsistencyPolicy;
        });
    }
}

